# Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA
#
# This file is part of Pandora, the Flexible Monitoring Platform.
#
# Pandora is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# Pandora is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Pandora; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

use Pandora;

$ofile = shift;
if (!$ofile) {
    print STDERR "usage: $0 <output_file> <lib_files> ...\n";
    exit(1);
}

if ($ofile eq "-") {
    $ohandle = STDOUT;
} else {
    open(OFILE, ">$ofile") or die "cannot open $ofile: $!";
    $ohandle = OFILE;
}

$defined{'__fake__'} = " ";

foreach $file (@ARGV) { 
    ($lib, $vers) = Pandora::findlib($file);
    ($dirname, $basename, $ext) = Pandora::split_file_name($file);
    next if !$lib;
    $base = core_name($lib);
    $version{$base} = $vers;
    $path{$base} = $dirname . "/" . $basename;

    open (SYMS, "$Pandora::NM $lib 2> /dev/null|") 
	or print STDERR "$0: $lib: Cannot extract symbols\n";
    
    ++$undefined{$base}{'__fake__'};
    
    while ($line = <SYMS>) {
	#print $line;
	if ($line =~ /T\s+(__pandora_([^_ \t\r\n]+)_(\w+))$/) {
	    $type = $2;
	    $ssym = $3;
	    $psyms{$base}{$ssym} = $type;
	}
	
	if ($line =~ /^\S+\s+[BCDEGRSTVW]\s+(\S+)$/) {
	    $symbol = $1;
	    #print "defined:   $1 ($base)\n";
	    if ($defined{$symbol}) {
		#print STDERR "potential symbol clash: $symbol defined in $defined{$symbol} and $base\n";
	    }
	    $defined{$symbol} = $base;
	    next;
	}
	
	if ($line =~ /^\s+[U]\s+(\S+)$/) {
	    next if ($base =~ /(libpandora|libputil)/);
	    $symbol = $1;
	    #print "undefined: $1 ($base)\n";
	    ++$undefined{$base}{$symbol};
	}
    }
    close(SYMS);
}

%deps = Pandora::finddeps(%defined, %undefined);

foreach $lib (keys %deps) {
    print $ohandle "[library] $lib $version{$lib} $path{$lib}\n";
    if ($#{ $deps{$lib} }) {
	print $ohandle "[dependency] $lib @{ $deps{$lib} }\n";
    }
}

foreach $lib (keys %psyms) {
    %ssyms = %{ $psyms{$lib} };
    foreach $ssym (keys %ssyms) {
	print $ohandle "[$ssyms{$ssym}] $ssym $lib\n";
    }
}

if (OFILE) {
    close(OFILE);
}
