# Copyright (C) 1999, 2000, 2001 Simon Patarin, INRIA
#
# This file is part of Pandora, the Flexible Monitoring Platform.
#
# Pandora is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# Pandora is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Pandora; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

$outfile = shift;
$infile = shift;

if (! -f $infile) {
    print "usage: $0 <output> <input>\n";
    exit 1;
}

open(OUT, ">$outfile") or die "can't open $outfile: $!";
open(IN, "$infile") or die "can't open $infile: $!";

$infile =~ /([^\/]+)$/;
$base = $1;

print OUT "const static char _" . $base . "_string_\[\] = \"string:\"\n";
while ($line = <IN>) {
    chop($line);
    $line =~ s/\\/\\\\/g;
    $line =~ s/\"/\\\"/g;
    print OUT "\"" . $line . "\\n\"\n";
}
print OUT ";\n";

close OUT;
close IN;
