/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef GTKCAIROMM_DEMO_H
#define GTKCAIROMM_DEMO_H

#include <gtkmm.h>

#include <papyrus/canvas.h>
#include <papyrus/rectangle.h>
#include <papyrus/png.h>
#include <papyrus/circle.h>
#include <papyrus/text.h>
#include <papyrus/lines.h>
#include <papyrus/polygon.h>
#include <papyrus/regularpolygon.h>

class Simple : public Gtk::Window
{

public:
  Simple();
  virtual ~Simple();

protected:
  //Signal handlers:

  //Member widgets:
  Gtk::VBox m_vbox;
  Gtk::Frame m_frame;
  Gtk::HScale m_slider;
  Gtk::HScale m_zoom;
  Gtk::CheckButton m_animate;
  Papyrus::Canvas m_canvas;
  Papyrus::Rectangle m_rect;
  Papyrus::PNG m_png;
  Papyrus::Circle m_circle;
  Papyrus::Text m_text;
  Papyrus::Lines m_lines;
  Papyrus::Polygon m_polygon;
  Papyrus::Rectangle m_bboxrect;
  Papyrus::Group m_bbox;
  Papyrus::RegularPolygon m_regularpolygon;
  Papyrus::Group m_grouped;

  void slider_changed();
  void zoom_changed();
  bool animate_step();
  void animate_toggled();
  void on_sig_size_allocate(Gtk::Allocation&);

  void adjust_canvas(int width, int height);

  void draw_scene();

  void update_bbox(double x, double y);

  bool on_click(GdkEventButton* button);

};

#endif // GTKCAIROMM_DEMO
