/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "boxedgroup.h"

using namespace Papyrus;

BoxedGroup::BoxedGroup()
 : Group(),
 m_bound(NULL),
 m_tied_dimensions(0)
{
}


BoxedGroup::BoxedGroup(Group& group)
  : Group(group),
 m_bound(NULL),
 m_tied_dimensions(0)
{
}


BoxedGroup::~BoxedGroup()
{
}

void BoxedGroup::tie( BBox& bounding, int dimensions )
{
  if (m_tied_connection)
    m_tied_connection.disconnect();
  m_bound = &bounding;
  m_tied_dimensions = dimensions;
  m_bound->signal_changed().connect(sigc::mem_fun(*this, &BoxedGroup::on_tied_bbox_changed));
  on_tied_bbox_changed(m_bound, BBOX_X|BBOX_Y|BBOX_WIDTH|BBOX_HEIGHT);
}

void BoxedGroup::untie() {
  if (m_tied_connection)
    m_tied_connection.disconnect();
}

void BoxedGroup::set_tied_dimensions( int dimensions )
{
  m_tied_dimensions = dimensions;
}

void BoxedGroup::on_tied_bbox_changed(Object*, int changed_dimensions )
{
  int changed = 0;
  double x=m_x, y=m_y, sx=m_scale_x, sy=m_scale_y;

  if (m_tied_dimensions & changed_dimensions & BBOX_X) {
    x = m_bound->get_x();
    changed |= RENDER_X;
  }

  if (m_tied_dimensions & changed_dimensions & BBOX_Y) {
    y = m_bound->get_y();
    changed |= RENDER_Y;
  }

  if (m_tied_dimensions & changed_dimensions & BBOX_WIDTH) {
    sx = m_bound->get_width() / get_bbox().get_width();
    changed |= RENDER_WIDTH;
  }

  if (m_tied_dimensions & changed_dimensions & BBOX_HEIGHT) {
    sy = m_bound->get_height() / get_bbox().get_height();
    changed |= RENDER_HEIGHT;
  }

  if (changed & (RENDER_X|RENDER_Y))
    set_xy(x, y);

  if (changed & (RENDER_WIDTH|RENDER_HEIGHT))
    set_scale(sx, sy);

  if (changed)
    on_changed(changed);

}



