/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef CANVAS_H
#define CANVAS_H

#include <vector>

// #include <gtkcairomm.h>

#include <gtkmm.h>

#include <papyrus/rgba.h>
#include <papyrus/group.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class Canvas: public Gtk::EventBox {

public:
    Canvas();
    virtual ~Canvas();

public:

    // Drawing Operations
    virtual void clear();

    void set_background_color(RGBA color);
    RGBA get_background_color() {
        return m_background_color;
    }

    // Properties
    Group& root() {
        return m_root;
    }

//   std::vector<Item*> pick(double x, double y, unsigned depth=1);

protected:
    RGBA m_background_color;
    Group m_root;

    virtual bool on_expose_event(GdkEventExpose* e);

    virtual void on_need_redraw(double x, double y, double w, double h);

}; // class Canvas

}
; // namespace Papyrus

#endif
