/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "lines.h"

using namespace Papyrus;

Lines::Lines(Vertices vertices):
        Shape(),
        Interface::Verts(vertices),
        m_cap(CAIRO_LINE_CAP_BUTT),
m_join(CAIRO_LINE_JOIN_MITER) {}

Lines::~Lines() {}

void Lines::draw_shape(cairo_t* cairo) {
    if (m_vertices.size() < 2)
        return;
    cairo_move_to(cairo, m_vertices[0].x, m_vertices[0].y);
    cairo_set_line_cap(cairo, m_cap);
    cairo_set_line_join(cairo, m_join);
    for (Vertices::iterator i = m_vertices.begin()+1; i != m_vertices.end(); i++) {
        cairo_line_to(cairo, i->x, i->y);
    }
}

void Lines::on_vertices_changed() {
    m_bbox.set_xywh(0.0, 0.0, 0.0, 0.0);
    if (m_vertices.size() > 0) {
        m_bbox.set_xywh(m_vertices[0].x, m_vertices[0].x, 0, 0);
        for (Vertices::iterator i = m_vertices.begin()+1; i != m_vertices.end(); i++)
            m_bbox.update(i->x, i->y);
    }
    on_changed(RENDER_BBOX);
}

cairo_line_cap_t Lines::get_line_cap() {
    return m_cap;
}

void Lines::set_line_cap(cairo_line_cap_t c) {
    m_cap = c;
    on_changed(RENDER_PATTERN);
}

cairo_line_join_t Lines::get_line_join() {
    return m_join;
}

void Lines::set_line_join(cairo_line_join_t j) {
    m_join = j;
    on_changed(RENDER_PATTERN);
}



