/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSLINES_H
#define PAPYRUSLINES_H

#include <papyrus/shape.h>
#include <papyrus/interface_vertices.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class Lines : public Shape, public virtual Interface::Verts
{
  public:
    Lines(Vertices vertices=Vertices());
    ~Lines();

    double get_line_width();
    void set_line_width(double w);

    cairo_line_cap_t get_line_cap();
    void set_line_cap(cairo_line_cap_t c);

    cairo_line_join_t get_line_join();
    void set_line_join(cairo_line_join_t j);

    virtual void draw_shape(cairo_t* cairo);

  protected:
    double m_line_width;
    cairo_line_cap_t m_cap;
    cairo_line_join_t m_join;


    virtual void on_vertices_changed();

};

}

#endif
