/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "png.h"

using namespace Papyrus;

PNG::PNG( ) :
    Drawable(),
    m_image(NULL),
    m_width(0.0),
    m_height(0.0)
{
}

PNG::PNG(std::string filename)  :
    Drawable(),
    m_image(NULL),
    m_width(0.0),
    m_height(0.0)
{
  set_filename(filename);
}

PNG::~PNG()
{
  if (m_image != NULL)
    cairo_surface_destroy(m_image);
}


void PNG::draw(cairo_t* cairo)
{
  if (m_image != NULL) {
    cairo_set_source_surface(cairo, m_image, 0, 0);
    cairo_paint(cairo);
  }
}

const std::string& PNG::get_filename( )
{
  return m_filename;
}

void PNG::set_filename( const std::string & filename )
{
  m_filename = filename;
  on_filename_changed();
}

void PNG::on_filename_changed()
{
  if (m_image != NULL)
    cairo_surface_destroy(m_image);

  if (m_filename != std::string()) {
    m_image = cairo_image_surface_create_from_png(m_filename.c_str());
    m_width = cairo_image_surface_get_width(m_image);
    m_height = cairo_image_surface_get_height(m_image);
    m_bbox.set_xywh(0.0, 0.0, m_width, m_height);
  }
  else {
    m_image = NULL;
    m_width = 0.0;
    m_height = 0.0;
    m_bbox.set_xywh(0.0, 0.0, m_width, m_height);
  }

  on_changed(RENDER_WIDTH|RENDER_HEIGHT|RENDER_BBOX);

}


