/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSPNG_H
#define PAPYRUSPNG_H

#include <papyrus/drawable.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class PNG : public Drawable
{
public:
  PNG();
  PNG(std::string filename);

    ~PNG();

    const std::string& get_filename();
    void set_filename(const std::string& filename);

    virtual void draw(cairo_t* cairo);

    double get_width() { return m_width; }
    double get_height() { return m_height; }

    void get_width_height(double& width, double& height) { width = m_width; height = m_height; }

  protected:
    std::string m_filename;
    double m_width, m_height;
    cairo_surface_t* m_image;

    void on_filename_changed();

};

}

#endif
