/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "regularpolygon.h"

#include <cmath>

using namespace Papyrus;

RegularPolygon::RegularPolygon(unsigned int sides, double radius, unsigned int style)
 : Polygon(),
 m_sides(sides),
 m_style(ZERO_VERTEX)
{
  m_radius = fabs(radius);
  if (style <= ZERO_APOTHEM)
    m_style = style;

  create_vertices();
}

RegularPolygon::~RegularPolygon()
{
}

unsigned int RegularPolygon::get_sides( )
{
  return m_sides;
}

void RegularPolygon::set_sides( unsigned int s )
{
  if (s >= 3) {
    m_sides = s;
    on_regularpolygon_changed();
  }
}

double RegularPolygon::get_radius( )
{
  return m_radius;
}

void RegularPolygon::set_radius( double r )
{
  m_radius = fabs(r);
  on_regularpolygon_changed();
}

void RegularPolygon::set_sides_radius( unsigned int s, double r )
{
  if (s >= 3) {
    m_sides = s;
  }
  m_radius = fabs(r);
  on_regularpolygon_changed();
}

double RegularPolygon::get_edge( )
{
  double angle, edge;
  angle = M_PI / m_sides;
  edge = sin(angle) * m_radius * 2.0;
  return edge;
}

void RegularPolygon::set_edge( double e )
{
  double angle;
  angle = M_PI / m_sides;
  m_radius = fabs(e) / 2.0 / sin(angle);
  on_regularpolygon_changed();
}

void RegularPolygon::set_sides_edge( unsigned int s, double e )
{
  double angle;
  if (s >= 3) {
    m_sides = s;
  }
  angle = M_PI / m_sides;
  m_radius = fabs(e) / 2.0 / sin(angle);
  on_regularpolygon_changed();
}

double RegularPolygon::get_apothem( )
{
  double angle, apothem;
  angle = M_PI / m_sides;
  apothem = cos(angle) * m_radius;
  return apothem;
}

void RegularPolygon::set_apothem( double a )
{
  double angle;
  angle = M_PI / m_sides;
  m_radius = fabs(a) / cos(angle);
  on_regularpolygon_changed();
}

void RegularPolygon::set_sides_apothem( unsigned int s, double a )
{
  double angle;
  if (s >= 3) {
    m_sides = s;
  }
  angle = M_PI / m_sides;
  m_radius = fabs(a) / cos(angle);
  on_regularpolygon_changed();
}

void RegularPolygon::on_regularpolygon_changed() {
  create_vertices();
  on_vertices_changed();
}

unsigned int RegularPolygon::get_style( )
{
  return m_style;
}

void RegularPolygon::set_style( unsigned int i )
{
  if (i <= ZERO_APOTHEM) {
    m_style = i;
    on_regularpolygon_changed();
  }
}

void RegularPolygon::create_vertices( )
{
  double angle=0.0, x, y;
  m_vertices.clear();

  if (m_style == ZERO_APOTHEM)
    angle += M_PI / m_sides;

  for (int i=0; i < m_sides; i++) {
    x = cos(angle) * m_radius;
    y = sin(angle) * m_radius;
    m_vertices.push_back(Vertex(x, y));
    angle += 2.0 * M_PI / m_sides;
  }

}
