/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSDRAWABLE_H
#define PAPYRUSDRAWABLE_H

#include <papyrus/object.h>
#include <cairo/cairo.h>
#include <iostream>

namespace Papyrus {

typedef enum RenderAttributes {
  RENDER_X            =1<<0,
  RENDER_Y            =1<<1,
  RENDER_SCALE_X      =1<<2,
  RENDER_SCALE_Y      =1<<3,
  RENDER_ROTATE       =1<<4,
  RENDER_WIDTH        =1<<5,
  RENDER_HEIGHT       =1<<6,
  RENDER_PATTERN      =1<<7,
  RENDER_RADIUS       =1<<8,
  RENDER_ANGLE_START  =1<<9,
  RENDER_ANGLE_FINISH =1<<10,
  RENDER_BBOX         =1<<11,
} RenderAttributes;

/**
 * A base class for any item capable of being rendered into a cairo.
 *
 * This class exists to provide a common base for all classes capable of rendering themselves
 * on a cairo surface. All children must supply their own version of render that is sufficient
 * to render themselves into the supplied cairo.
 *
 * The render method is a pure virtual method, forcing all derived children to implement their
 * own render methods.
 *
 * @author Rick L Vinyard Jr
 */
class Renderable: public virtual Papyrus::Object {
  public:
    /**
   * TODO: revisit the use of these
   * typedef enum Optimization {SPEED, MEMORY} Optimization;
     */

    Renderable(): Papyrus::Object() { }

    virtual ~Renderable() { }

    virtual void render(cairo_t* cairo) = 0;

  protected:

    virtual void on_changed(int i) {
      m_signal_changed.emit(this, i);
    }

};

};

#endif

