/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#include "text.h"

using namespace Papyrus;

Text::Text(std::string text, double size):
  Shape(),
  m_text(text),
  m_size(size)
{
}

Text::~Text() {}

double Text::get_size() {
    return m_size;
}

void Text::set_size(double size) {
    m_size = size;
    on_changed(RENDER_WIDTH|RENDER_HEIGHT|RENDER_BBOX);
}

const std::string& Text::get_text() {
    return m_text;
}

void Text::set_text(const std::string text) {
    m_text = text;
    on_changed(RENDER_WIDTH|RENDER_HEIGHT|RENDER_BBOX);
}

void Text::draw_shape(cairo_t* cairo) {
  cairo_text_extents_t extents;

  cairo_set_font_size(cairo, m_size);
  cairo_text_path(cairo, m_text.c_str());

  cairo_text_extents(cairo, m_text.c_str(), &extents);
  m_bbox.set_xywh(0.0, -extents.height, extents.width, extents.height);
}

