/***************************************************************************
 *   Copyright (C) 2004 by Rick L. Vinyard, Jr.                            *
 *   rvinyard@cs.nmsu.edu                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation version 2.1.                *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA              *
 ***************************************************************************/
#ifndef PAPYRUSTEXT_H
#define PAPYRUSTEXT_H

#include <string>

#include <papyrus/shape.h>

namespace Papyrus {

/**
@author Rick L Vinyard Jr
*/
class Text : public Shape
{
public:
  Text(std::string text=std::string(), double size=12.0);

  ~Text();

  double get_size();
  void set_size(double);

  const std::string& get_text();
  void set_text(const std::string);

  virtual void draw_shape(cairo_t* cairo);

protected:
  std::string m_text;
  double m_size;
};

}

#endif
