from Globals import DTMLFile, ImageFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from OFS.SimpleItem import Item
from Products.TemporaryFolder.TemporaryFolder import MountedTemporaryFolder
import Products.ZPsycopgDA.DA
from mx.DateTime import *
import smtplib
import DateTime

from Products.Pratiche import utils

class Anagrafe(Folder):    
    "Application Anagrafe"

    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')

    meta_type = 'PAX - Anagrafe Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )


    security.declareProtected('Pax Use', 'index_html')   
    index_html = PageTemplateFile('template/index_html.pt', globals())
    cambioIndirizzo = PageTemplateFile('template/cambioIndirizzo.pt', globals())
    statoFamiglia = PageTemplateFile('template/statoFamiglia.pt', globals())
    attoNotorieta = PageTemplateFile('template/attoNotorieta.pt', globals())            
    
    def __init__(self, id, title):
        "initialise a new instance of Anagrafe Application"
        self.id = id
        self.title = title


    security.declareProtected('Pax Add Anagrafe', 'manage_editAnagrafeAction')
    def manage_editAnagrafeAction(self, RESPONSE=None):
        "Edit Anagrafe Application."
        self._p_changed = 1
        RESPONSE.redirect('manage_main')

        return

    security.declareProtected('Pax Use', 'datiAnagrafici')            
    def datiAnagrafici(self, REQUEST):
        "datiAnagrafici"

        session=REQUEST.SESSION
        
        username = session['username']
        
        strsql = "select * from elettorale, vie where cf = '%s' and elettorale.cod_via = vie.id ;" % username

        results=utils.runMappedQuery(self.getConnection(),strsql)
  
        return results[0]


    security.declareProtected('Pax Use', 'famiglia')            
    def famiglia(self,REQUEST):
        "famiglia"

        session=REQUEST.SESSION
        
        username = session['username']

        strsql="select * from elettorale where cod_famiglia in ( select cod_famiglia from elettorale where cf = '%s') and cf <> '%s'" % (username,username)

        results=utils.runMappedQuery(self.getConnection(),strsql)
        
        return results


    security.declareProtected('Pax Use', 'vie')            
    def vie(self,REQUEST):
        "vie"

        session=REQUEST.SESSION
        
        username = session['username']
        
        strsql = "select * from vie order by nomevia" 

        results=utils.runMappedQuery(self.getConnection(),strsql)
          
        return results


    security.declareProtected('Pax Use', 'eta')            
    def eta(self,data_n,anni=None):
        "eta"

        early=DateTime.DateTime()

        early=DateTime.DateTime(early.year()-anni, early.month(), early.day())

        return early.greaterThanEqualTo(data_n)


    security.declareProtected('Pax Use', 'actioncambioIndirizzo')            
    def actioncambioIndirizzo(self,REQUEST=None,RESPONSE=None):
        "actioncambioIndirizzo"


        session=REQUEST.SESSION
        
        cimodule = self.getItemModule('CambioIndirizzo')    
        ci = cimodule.CambioIndirizzo()

        ci.set_attributes(REQUEST.form)

        attrs={'Oggetto':'Cambio Indirizzo','anno':DateTime.now().strftime("%Y"),'utenteinserimento': session['username'] ,'id_anag':'2334','DataRegistrazione':ci.DataRegistrazione}
      
        ci.set_attributes(attrs)
        ci.insert_data()
        ci.send()
        
        RESPONSE.redirect('./?message='+'Segnalazione inviata con successo')
    

manage_addAnagrafeForm = DTMLFile('template/manage_addAnagrafeForm', globals())

def manage_addAnagrafeAction(self, id, title, visible, RESPONSE=None):
    "Add a Anagrafe Application to a folder."
    ob = Anagrafe(id, title)
    self._setObject(id, ob)

    ob.manage_addProperty('visible', visible, 'boolean')
    
    RESPONSE.redirect('manage_main')
