CREATE TABLE "a_titoli" (
	"id_titolo" character varying(10) DEFAULT '' NOT NULL,
	"des_titolo" character varying(250),
	"tipo" character(1)
);

--
-- TOC Entry ID 5 (OID 1284002)
--
-- Name: a_titoli Type: ACL Owner: 
--

REVOKE ALL on "a_titoli" from PUBLIC;
GRANT ALL on "a_titoli" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "a_titoli" to all;

--
-- TOC Entry ID 2 (OID 1284084)
--
-- Name: form_utente_id_prot_seq Type: SEQUENCE Owner: postgres
--

CREATE SEQUENCE "form_utente_id_prot_seq" start 1 increment 1 maxvalue 9223372036854775807 minvalue 1 cache 1;

--
-- TOC Entry ID 3 (OID 1284084)
--
-- Name: form_utente_id_prot_seq Type: ACL Owner: 
--

REVOKE ALL on "form_utente_id_prot_seq" from PUBLIC;
GRANT ALL on "form_utente_id_prot_seq" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "form_utente_id_prot_seq" to all;

--
-- TOC Entry ID 6 (OID 1284089)
--
-- Name: pratiche_azioni Type: TABLE Owner: postgres
--

CREATE TABLE "pratiche_azioni" (
	"id_pratica" character varying(9) DEFAULT '' NOT NULL,
	"id" integer DEFAULT '0' NOT NULL,
	"descrizione" character varying(245),
	"non_richiesto" integer,
	"eseguibile_da_web" integer,
	"fattibile" integer DEFAULT '0' NOT NULL,
	"verificato" integer,
	"posizione" integer,
	"fatto" integer DEFAULT '0',
	"nota_esatto" character varying(250),
	"ord_fase" character(16),
	"ripetitivo" integer
);

--
-- TOC Entry ID 7 (OID 1284089)
--
-- Name: pratiche_azioni Type: ACL Owner: 
--

REVOKE ALL on "pratiche_azioni" from PUBLIC;
GRANT ALL on "pratiche_azioni" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "pratiche_azioni" to all;

--
-- TOC Entry ID 8 (OID 1284099)
--
-- Name: pratiche_utenti Type: TABLE Owner: postgres
--

CREATE TABLE "pratiche_utenti" (
	"tipo_anag" character(1) DEFAULT '' NOT NULL,
	"id_anag" integer DEFAULT '0' NOT NULL,
	"id_pratica" character varying(9) DEFAULT '' NOT NULL,
	"abilitato_web" integer,
	"id_titolo" character(10)
);

--
-- TOC Entry ID 9 (OID 1284099)
--
-- Name: pratiche_utenti Type: ACL Owner: 
--

REVOKE ALL on "pratiche_utenti" from PUBLIC;
GRANT ALL on "pratiche_utenti" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "pratiche_utenti" to all;

--
-- TOC Entry ID 10 (OID 1284103)
--
-- Name: stato_pratica Type: TABLE Owner: postgres
--

CREATE TABLE "stato_pratica" (
	"codice" integer,
	"descriz" character(128)
);

--
-- TOC Entry ID 11 (OID 1284103)
--
-- Name: stato_pratica Type: ACL Owner: 
--

REVOKE ALL on "stato_pratica" from PUBLIC;
GRANT ALL on "stato_pratica" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "stato_pratica" to "all";

--
-- TOC Entry ID 12 (OID 1284123)
--
-- Name: utenti Type: TABLE Owner: postgres
--

CREATE TABLE "utenti" (
	"cf" character varying(16) DEFAULT '' NOT NULL,
	"email" character varying(50) DEFAULT '' NOT NULL,
	"password" character varying(10) DEFAULT '' NOT NULL,
	"newpassword" character varying(10) DEFAULT '',
	"ts" character varying(50) DEFAULT '0',
	Constraint "utenti_pkey" Primary Key ("cf")
);

--
-- TOC Entry ID 13 (OID 1284123)
--
-- Name: utenti Type: ACL Owner: 
--

REVOKE ALL on "utenti" from PUBLIC;
GRANT ALL on "utenti" to "postgres";
GRANT INSERT,SELECT,UPDATE,DELETE on "utenti" to "all";

--
-- TOC Entry ID 14 (OID 5484789)
--
-- Name: elenco_pratiche Type: TABLE Owner: postgres
--

CREATE TABLE "elenco_pratiche" (
	"id_pratica" character varying(9) DEFAULT '' NOT NULL,
	"cod_interno" character varying(50),
	"desc_pratica" character varying(250),
	"stato" integer,
	"cod_anag_resp" character varying(9) DEFAULT '0' NOT NULL
);

--
-- TOC Entry ID 15 (OID 5511731)
--
-- Name: utenti_abilitati_web Type: TABLE Owner: postgres
--

CREATE TABLE "utenti_abilitati_web" (
	"tipo_anag" character(1) DEFAULT '' NOT NULL,
	"id_anag" integer DEFAULT '0' NOT NULL,
	"cod_fisc" character varying(16) DEFAULT '' NOT NULL,
	"password" character varying(30) DEFAULT '' NOT NULL,
	"nominativo" character varying(50) DEFAULT '' NOT NULL,
	"sesso" character(1),
	"e_mail" character varying(100),
	"cod_utente" character varying(16) DEFAULT ''
);

--
-- TOC Entry ID 16 (OID 5542127)
--
-- Name: pratiche_documenti Type: TABLE Owner: postgres
--

CREATE TABLE "pratiche_documenti" (
	"id_pratica" character varying(9) DEFAULT '' NOT NULL,
	"id_doc" character varying(10) DEFAULT '' NOT NULL,
	"tipo" character varying(8) DEFAULT '' NOT NULL,
	"data_protocollo" character varying(12),
	"oggetto" character varying(250),
	"rif_mittente" character varying(15),
	"data_mittente" character varying(12),
	"cod_amm" character varying(8),
	"cod_area" character varying(8)
);

--
-- TOC Entry ID 17 (OID 5543224)
--
-- Name: view_form_utente Type: VIEW Owner: postgres
--

CREATE VIEW "view_form_utente" as SELECT form_utente.id_prot, form_utente.id_anag, form_utente.data_protocollo, form_utente.id_pratica, form_utente.id_passo, form_utente.cod_amm, form_utente.cod_area, form_utente.testo, form_utente.oggetto FROM form_utente WHERE (form_utente.esportato IS NULL);

--
-- TOC Entry ID 18 (OID 5543444)
--
-- Name: temp Type: TABLE Owner: postgres
--

CREATE TABLE "temp" (
	"id_prot" character varying(10),
	"id_anag" integer,
	"data_protocollo" character varying(10),
	"id_pratica" character varying(9),
	"id_passo" integer,
	"cod_amm" character varying(8),
	"cod_area" character varying(8),
	"testo" character varying(250),
	"oggetto" character varying(50)
);

--
-- TOC Entry ID 19 (OID 5544326)
--
-- Name: form_utente Type: TABLE Owner: postgres
--

CREATE TABLE "form_utente" (
	"id_prot" character varying(10),
	"id_anag" integer DEFAULT '0' NOT NULL,
	"data_protocollo" character varying(10) DEFAULT '01/01/2003' NOT NULL,
	"id_pratica" character varying(9) DEFAULT '' NOT NULL,
	"id_passo" integer DEFAULT '0' NOT NULL,
	"cod_amm" character varying(8),
	"cod_area" character varying(8),
	"testo" character varying(250) DEFAULT '' NOT NULL,
	"oggetto" character varying(50) DEFAULT '' NOT NULL
);

