"""EventoCalendarioType main class"""


from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
import string

from Products.ZCatalog.CatalogPathAwareness import CatalogPathAware
from Products.CMFCore.CMFCorePermissions import View, ManageProperties, ListFolderContents
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFCore.PortalContent import PortalContent
from Products.CMFCore import CMFCorePermissions
from AccessControl import Permissions, getSecurityManager, ClassSecurityInfo, Unauthorized
from OFS import Folder

import mx.DateTime
#from mx.DateTime import *

import DateTime

#from DateTime import DateTime



from global_symbols import *



# EventoCalendarioType definition
factory_type_information = {
  'id'             : 'EventoCalendarioType',
  'portal_type'    : 'EventoCalendarioType',
  'meta_type'      : 'Evento Calendario',
  'description'    : 'Evento Calendario',
  'content_icon'   : 'MinimalContentType.gif',                          # Icon has to be acquired from a skin folder
  'product'        : 'EventoCalendario',
  'factory'        : 'addEventoCalendarioType',
  'immediate_view' : 'EventoCalendarioType_edit',
  'filter_content_types' : 0,                                   # This is for folderish types
  'allowed_content_types': (),                                  # If filter_content_types is true, this field can hold allowed meta_types
  'actions': (
    {
    'id'           : 'view',
    'name'         : 'View',
    'action'       : 'EventoCalendarioType_view',
    'permissions'  : (CMFCorePermissions.View, ),
    'category'      : 'object',
    },
    {
    'id'           : 'edit',
    'name'         : 'Edit',
    'action'       : 'portal_form/EventoCalendarioType_editForm',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    {
    'id'            : 'metadata',
    'name'          : 'Metadata',
    'action'        : 'metadata_edit_form',
    'permissions'   : (CMFCorePermissions.ModifyPortalContent, ),
    'category'      : 'object',
    },
    ),
  }
  
# The usual factory
def addEventoCalendarioType(self, id, title = '', REQUEST = {}):
    """
    Factory method for a EventoCalendarioType object
    """
    obj = EventoCalendarioType(id, title)
    self._setObject(id, obj)

    if REQUEST.has_key('RESPONSE'):
        return REQUEST.RESPONSE.redirect('manage_main')



class EventoCalendarioType(PortalContent, DefaultDublinCoreImpl):
    """EventoCalendarioType class"""
    meta_type = factory_type_information['meta_type']                   # Has not to be the same as FTI but it is the most usual case.

    manage_options = PortalContent.manage_options

    text = ""           # Default text

    # Standard security settings
    security = ClassSecurityInfo()
    security.declareObjectProtected(CMFCorePermissions.View)            # $$$ Is this clever ? Isn't it better to make the object private ?


    # Init method
    def __init__(self, id, title='', location='', subject='', startdate='', enddate=''):
        """__init__(self, id, title='')"""

        self.id = id
        self.title = title
        self.idlocation = location
        self.idsubject = subject
        self.startdate = mx.DateTime.now()
        self.enddate = mx.DateTime.now()

    # Class-internal factory method
    security.declareProtected(EventoCalendarioType_addPermission, 'manage_addEventoCalendarioType')
    def manage_addEventoCalendarioType(self, id, title='', REQUEST=None):
        """ adds a new PloneFolder """
        ob=PloneFolder(id, title)
    	self._setObject(id, ob)
    	if REQUEST is not None:
            return self.folder_contents(self, REQUEST, portal_status_message='Added content.')


    security.declareProtected(EventoCalendarioType_editPermission, 'getLocations')
    def getLocations(self,idloc=None):
        """
        get locations
        """
        # Change attributes

        cnx = getattr(self, "pratiche_dbcnx", None)
        if cnx:
            CNX__ = cnx()


        if not idloc:
            sql_string = "select a.id, a.citta, a.descrizione, a.id_pratica, a.civico, a.sub, b.nomevia , a.sito from location a left join  vie b on a.codcitta = b.cod_comune and a.codvia = b.id where a.calendario=1 order by citta, descrizione"
        else:
            sql_string = "select a.id, a.citta, a.descrizione, a.id_pratica, a.civico, a.sub,  b.nomevia , a.sito from location a left join  vie b on a.codcitta = b.cod_comune and a.codvia = b.id where  a.id = '%s' and a.calendario=1 order by citta, descrizione" % idloc

        items, results = CNX__.query(sql_string)

	CNX__.tpc_finish()

        locations=[]
        for result in results:
            location={'id':str(result[0])}
            location['desc']=result[1] + ', ' + result[2]
            location['id_pratica']=result[3] or ''
            location['nomevia']=result[6] or ''
            location['civico']=result[4] or ''
            location['sub']=result[5] or ''
            location['sito']=result[7] or ''
            locations.append(location)
            
        return locations


    security.declareProtected(EventoCalendarioType_editPermission, 'getEventTypes')
    def getEventTypes(self, idtype=None):
        """
        getevents type
        """
        # Change attributes
        cnx = getattr(self, "pratiche_dbcnx",None)
        if cnx:
            CNX__ = cnx()

        if not idtype:
            sql_string = "select * from tipievento order by descrizione,sottocategoria"
        else:
            sql_string = "select * from tipievento where id = '%s' order by descrizione,sottocategoria " % idtype
        

        items, results = CNX__.query(sql_string)

        eventtypes=[]
        for result in results:
            eventtype={'id':result[0]}
            eventtype['desc']=result[1] + ', ' + result [2]
            eventtypes.append(eventtype)
            
	CNX__.tpc_finish()

        return eventtypes


    security.declarePublic('Eventtype')
    def Eventtype(self):
        """
                """
        # Change attributes
        return self.idsubject


    security.declarePublic('Title')
    def Title(self):
        """
                """
        # Change attributes
        return self.title

    security.declarePublic('location')
    def location(self):

	locations=self.getLocations(self.idlocation)
	return locations[0]['desc']


    security.declarePublic('DescLocation')
    def DescLocation(self,full=None):
        locations=self.getLocations(self.idlocation)

        
        if len(locations)>0:
            if full:
                return locations[0]
            else:
                return locations[0]['desc']
        else:
            return 'Non specificato'


    security.declarePublic('Subject')
    def Subject(self):
        ""

#	return ""

	if not hasattr(self,'idsubject'):
	    return ''

        subjects=self.getEventTypes(self.idsubject)
                                       

	if len(subjects)<1:
		return ''
                                                            
        return [subjects[0]['desc'],]


    security.declarePublic('DescEvent')
    def DescEvent(self):
        eventtype=self.getEventTypes(self.idsubject)

        return eventtype[0]['desc']


    security.declarePublic('viewMap')
    def viewMap(self):
        """
        """
        locations=self.getLocations(self.idlocation)

#        raise locations[0]['id_pratica']
    
        return self.visualizzamappa(id_pratica=locations[0]['id_pratica'])
        



    security.declarePublic('Location')
    def Location(self):
        """
        """
        return self.idlocation


    security.declarePublic('Text')
    def Text(self):
        """
        """
        return self.text

    security.declarePublic('isSameDay')
    def isSameDay(self):
        """
        """
        return self.startdate.strftime('%d%m%Y')==self.enddate.strftime('%d%m%Y')

    security.declarePublic('start')
    def start(self):
        """
            Return our start time as a string.
        """
#	d=self.startdate
	
	return DateTime.DateTime(self.startdate.gmtime().gmticks())
#        return self.startdate
 
    security.declarePublic('end')
    def end(self):
        """
            Return our stop time as a string.
        """
        return DateTime.DateTime(self.enddate.gmtime().gmticks())


    security.declarePublic('getMonths')
    def getMonths(self):
        """
            Return our stop time as a string.
        """
        months = range(1,13)
        return months


    security.declarePublic('getYears')
    def getYears(self):
        """
            Return our stop time as a string.
        """
        years = range(2004,2006)
        return years

    security.declarePublic('getDays')
    def getDays(self):
        """
            Return our stop time as a string.
        """

        days = range(1,32)
        return days


    security.declarePublic('getHours')
    def getHours(self):
        """
            Return our stop time as a string.
        """

        hours = range(0,24)
        return hours


    security.declarePublic('getMinutes')
    def getMinutes(self):
        """
            Return our stop time as a string.
        """

        minutes = range(0,60,5)
        return minutes



    # Edit method (change this to suit your needs)
    # This edit method should only change attributes that are neither 'id' or metadatas.
    security.declareProtected(EventoCalendarioType_editPermission, 'manage_editEventoCalendarioType')
    def manage_editEventoCalendarioType(self, title = '', text = '', subject='', location='', startdate='', enddate='' , REQUEST = {}):
        """
        manage_editEventoCalendarioType(self, title = '', text = '', REQUEST = {}) => object modification method
        """
        # Change attributes
        self.title = title
        self.text = text
        self.idlocation = location
	self.idsubject = subject

	datestr='%s-%s-%s %s:%s' % (startdate['frommonth'],startdate['fromday'],startdate['fromyear'],startdate['fromhour'].zfill(2),startdate['fromminute'].zfill(2))

        self.startdate = mx.DateTime.DateTimeFrom(datestr)

	datestr='%s-%s-%s %s:%s' % (enddate['tomonth'],enddate['today'],enddate['toyear'],enddate['tohour'].zfill(2),enddate['tominute'].zfill(2))

#	raise datestr

        self.enddate =  mx.DateTime.DateTimeFrom(datestr)

        self.reindexObject()
        
        # Redirect
#    	if REQUEST is not None:
#            return self.folder_contents(self, REQUEST, portal_status_message='Updated content.')
        

manage_addEventoCalendarioType = EventoCalendarioType.manage_addEventoCalendarioType


# Class instanciation
InitializeClass(EventoCalendarioType)


