from OFS import SimpleItem
from Globals import DTMLFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from OFS.SimpleItem import Item
from OFS.Folder import Folder

import simpleComm
 
# Comunicazione generica che pu essere fatta da web  
class zopeComm(simpleComm.simpleComm, SimpleItem.SimpleItem):
    "Comunicazione generica che pu essere fatta da web"
  
    meta_type = 'Pax Web Comm'
    
    icon = 'www/Folder_axia.gif'
      
    manage_options = (
        (
        {'label':'View', 'action':'index_html'},
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )
  
    def __init__(self, zopeComm_id, schema=None):
        "initialise a new instance of zopeComm"
        self.id = zopeComm_id

        # se inizializzata con uno schema...
        if schema:
            self.setSchema(schema)
        else:
            self.setSchema(self.commercio())


    index_html = PageTemplateFile('template/zopeComm_index.pt', globals())
    edit = PageTemplateFile('template/zopeComm_edit.pt', globals())
    showform = PageTemplateFile('template/zopeComm_form.pt', globals())



    def goForm(self, REQUEST=None, RESPONSE=None):
        "avvia lo showform o l'applicazione esterna"

        pars = REQUEST
        if self.getExtAppl() == 'composeForm':
            RESPONSE.redirect('showform')
        else:
            RESPONSE.redirect(self.getExtAppl(pars))

        return
    

    def getCursor(self):
        "restituisce il cursore prendendo la connessione dal container"

        paxInst = self.aq_parent
        cursor = paxInst.getCursorDB()

        return cursor
    

    def getProtocolNumber(self, c, u):
        "restituisce il numero di protocollo e esegue la insert"

        paxInst = self.aq_parent
        pn = paxInst.getNumeroRegistrazione(c, u)

        return pn


    def storeProtocol(self, c, u, d):
        "allega i dati alla insert fatta precedentemente"

        paxInst = self.aq_parent
        res = paxInst.storeProtocollo(c, u, d)

        return res
        
    

    def getUser(self, REQUEST):
        "restituisce l'id dell'utente autenticato su Zope"

        return REQUEST.SESSION['tnick']
    
    

    def editZopeCommAction(self, REQUEST, RESPONSE=None):
        "impostazione dello schema della comunicazione"

        if REQUEST.has_key('schema'):
            exec('schema=' + str(REQUEST['schema']))
        else:
            schema = []

        extAppl = str(REQUEST['extAppl'])
        
        self.setSchema(schema, extAppl)

        RESPONSE.redirect('../')

        return
    

    def actionForm(self, REQUEST, RESPONSE=None):
        "gestione dei dati inviati dal form"


        if self.getExtAppl() == 'composeForm':
            schema = self.getSchema()
            diz = {}
            for sf in schema: # vediamo di acquisire i dati...
                n = int(sf['nums'])
                for i in range(0,n):
                    for c in sf['ctrls']:
                        chiave = c['name']
                        valore = getattr(REQUEST, c['name'])
                        diz[chiave] = valore
        else:
            #raise "oggetto: %s" % REQUEST['oggetto']
            diz = {'oggetto':REQUEST['oggetto'], 'testo':REQUEST['testo']}

        nr = self.storeValue(diz, REQUEST)
            
        url = "%s?&id_protocollo=%s&id_pratica=%s&id_passo=%s&ripetitivo=%s&oggetto=%s&testo=%s"\
              % (REQUEST['send'],
                 nr,
                 REQUEST['id_pratica'],
                 REQUEST['id_passo'],               
                 0,
                 REQUEST['oggetto'],
                 REQUEST['testo']
                 ) # ...ehm...
        RESPONSE.redirect(url)
        return

    

    def composeForm(self, RESPONSE=None):
        "Scrive la form di acquisizione comunicazione web"

        schema = self.getSchema()
        f = "<form action='actionForm' method='post'>\n"
        for sf in schema: # slicing degli array di controlli
            n = int(sf['nums'])
            f += "%s<br/>" % sf['text']
            for i in range(0,n):
                if n>1:
                    f += "%s" % sf['labels'][i]
                for c in sf['ctrls']:
                    if c['control'] == 'text':
                        f += "<input type='text' name='%s:%s' %s/>\n" % (c['name'], c['type'], c['extra'])
                    elif c['control'] == 'select':
                        f += "<select name='%s'>\n" % c['name']
                        for s in c['options']:
                            f += "<option value='%s'>%s</option>\n" % (s['value'], s['label'])
                            f += "</select>\n"
                        f += "<br/>"
                    elif c['control'] == 'textarea':
                        f += "<textarea name='%s'></textarea>" % (c['name'])
                        f += "<br/>"
                    f += "<br/>"
        f += "<input type='submit'/>\n"
        f += "</form>"

        return f


