from Globals import DTMLFile, ImageFile
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from OFS.PropertyManager import PropertyManager
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo, getSecurityManager
from Products.TemporaryFolder.TemporaryFolder import MountedTemporaryFolder
from OFS.Folder import Folder
from OFS.SimpleItem import Item
#from mx.DateTime import *

import smtplib
import time
import sys
import os
import ConfigParser

import utils
from UsersTool import UsersTool



# Classe principale dell'applicazione

class Pratiche(Folder):    
    "Folder dell'applicazione Pratiche lato Zope"

    security = ClassSecurityInfo()
    
    __ac_roles__=('pax_webuser',
                  'Manager',
                  'Anonymous')

    meta_type = 'Pratiche Application'
  
    manage_options = (
        (
        {'label':'Contents', 'action':'manage_main'},
        {'label':'View', 'action':'index_html'},
        {'label':'Gestione Utenti', 'action':'manage_users'},        
        ) +
        PropertyManager.manage_options +
        RoleManager.manage_options +
        Item.manage_options
    )

    manage_users = PageTemplateFile('template/manage_users.pt', globals())    
    main_template = PageTemplateFile('template/main_template.pt', globals())
    macropratiche = PageTemplateFile('template/macropratiche.pt', globals())        
    index_html = PageTemplateFile('template/login.pt', globals())
    home = PageTemplateFile('template/home.pt', globals())
    listpratiche = PageTemplateFile('template/listpratiche.pt', globals())
    dettpratica = PageTemplateFile('template/dettpratica.pt', globals())
    docpratica = PageTemplateFile('template/docpratica.pt', globals())
    changepass = PageTemplateFile('template/changepass.pt', globals())
    datiUtente = PageTemplateFile('template/datiUtente.pt', globals())    
    passwordchanged = PageTemplateFile('template/passwordchanged.pt', globals())
    logouttemplate = PageTemplateFile('template/logout.pt',globals())
    permissiondenied = PageTemplateFile('template/permissiondenied.pt',globals())
    standard_error_message = PageTemplateFile('template/standard_error_message.pt',globals())    


    def __init__(self, id):
        "initialise a new instance of Pratiche Application"    

        self.id = id
        return



    security.declareProtected('Pax Use', 'getConnection')    
    def getConnection(self):
        "Returns a db connection stored in zodb"
    
        try:
            cnx = getattr(self, self.connectionName)
            if cnx: CNX__ = cnx()
            return CNX__
        except:
            raise "Impossibile collegarsi al database"


    security.declareProtected('Pax Use', 'getItemModule')    
    def getItemModule(self,ItemName):
        "returns the module of specified item"

        config = ConfigParser.ConfigParser()

        path = os.path.dirname(__file__) + '/ipax/'
         
#        config.read( path + "ipax.ini" )

#        if not config.has_section(ItemName):
#            raise 'Errore nella lettura del file di configurazione'            

#        module_path = config.get(ItemName,'path')
        module_path = path + ItemName
        
        sys.path=[path,module_path]+filter(None, sys.path)

        module = __import__(ItemName)
    
        return module
    

    security.declareProtected('Pax Use', 'pax_path')    
    def pax_path(self):
        "returns absolute path"

        path=''

        for item in self.getPhysicalPath():
            path += item + '/'

        return path
        

        
    security.declareProtected('Pax Use', 'actionStep')    
    def actionStep(self, REQUEST=None):
        "completa l'azione della pratica"

        if REQUEST==None:
            REQUEST.RESPONSE.redirect('../listpratiche')

        session = REQUEST.SESSION
        id_anag = session['idanag']
        
        ripetitivo = REQUEST.get('ripetitivo', 1)
        id_pratica = REQUEST.get('id_pratica', '')
        id_passo = REQUEST.get('id_passo', '')
        oggetto = REQUEST.get('oggetto', '')
        testo = REQUEST.get('testo', '')
        id_protocollo = REQUEST.get('id_protocollo', '')

        ammattr = self.pax.getAmmAttr()
            
        cod_amm =  ammattr['codiceAmministrazione']
        cod_area = ammattr['codiceAOO']

        now = time.time()
        ts = int(now)

        data_protocollo = time.strftime("%m/%d/%Y", time.localtime(now))

        # scrittura nel database pratiche

        strsql = "insert into form_utente (ID_PROT, DATA_PROTOCOLLO, ID_ANAG, ID_PRATICA, ID_PASSO, \
        OGGETTO, TESTO, COD_AMM, COD_AREA) \
        values ('%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s')" \
        % (id_protocollo, data_protocollo, id_anag, id_pratica, id_passo, oggetto, '', cod_amm, cod_area)

        utils.runQuery(self.getConnection(), strsql)
        
        strsql = "UPDATE pratiche_azioni SET FATTO=1 WHERE ID_PRATICA='%s' AND id='%s'" \
        % (id_pratica, id_passo)

        utils.runQuery(self.getConnection(), strsql)
        
        REQUEST.RESPONSE.redirect('../listpratiche')

        return strsql


    security.declareProtected('Pax Use', 'listSteps')        
    def listSteps(self, id_pratica, REQUEST, tutti):
        "lista delle azioni sulla pratica"

        session = REQUEST.SESSION

        idanag = session['idanag']

        if tutti=='no':
             strsql="select pa.*, pa.fattibile as STATO, sp.descriz , pu.abilitato_web from pratiche_azioni pa , stato_pratica sp , elenco_pratiche ep, pratiche_utenti pu  where pa.id_pratica = '%s' and pa.fattibile = sp.codice and ep.stato = pa.fattibile and ep.id_pratica = pa.id_pratica and pa.id_pratica = pu.id_pratica " % (id_pratica)

        else:
             strsql="select pa.* , pa.fattibile as STATO, sp.descriz, pu.abilitato_web from pratiche_azioni pa , stato_pratica sp where pa.id_pratica = '%s' and pa.fattibile = sp.codice and pa.id_pratica = pu.id_pratica" %  (id_pratica)

        return utils.runMappedQuery(self.getConnection(),strsql)

 	 
    security.declarePublic('Pax Use', 'checkPermission')
    def checkPermission(self, REQUEST=None):
        "Controlla se l'utente e' abilitato a l'iterazione con la pratica"

        self.validSession(REQUEST)        
           
        session = REQUEST.SESSION
   
        if not session.has_key('idanag'):
            REQUEST.RESPONSE.redirect(self.pax_path()+'./?errormsg='+"Sessione scaduta")
            return 0

        id_pratica = REQUEST['id_pratica']
            
        idanag = session['idanag']
        
        strsql = "select pratiche_utenti.ID_PRATICA, \
        elenco_pratiche.COD_INTERNO, \
        elenco_pratiche.DESC_PRATICA, \
        stato_pratica.DESCRIZ, \
        pratiche_utenti.ABILITATO_WEB \
        from pratiche_utenti, elenco_pratiche, stato_pratica \
        where pratiche_utenti.ID_ANAG='%s' \
        and pratiche_utenti.ID_PRATICA=elenco_pratiche.ID_PRATICA \
        and pratiche_utenti.ID_PRATICA='%s' \
        and elenco_pratiche.STATO=stato_pratica.CODICE" % (idanag, id_pratica)
        
        (desc,values)=utils.runQuery(self.getConnection(),strsql)

        if len(values):
            return 1
        else:
            REQUEST.RESPONSE.redirect(self.pax_path()+'./permissiondenied?errormsg='+"Accesso negato!")


    security.declareProtected('Pax Use', 'dettagliPratica')        
    def dettagliPratica(self, REQUEST=None):
        "documenti allegati alla pratica"

        id_pratica=REQUEST['id_pratica']
       
        strQuery = "select elenco_pratiche.COD_INTERNO , elenco_pratiche.DESC_PRATICA,  CASE WHEN utenti_abilitati_web.NOMINATIVO IS NULL THEN 'Non precisato o non abilitato' ELSE utenti_abilitati_web.NOMINATIVO END, CASE WHEN utenti_abilitati_web.E_MAIL IS NULL THEN '' ELSE utenti_abilitati_web.E_MAIL END, stato_pratica.DESCRIZ from ( elenco_pratiche  LEFT JOIN utenti_abilitati_web ON elenco_pratiche.COD_ANAG_RESP=utenti_abilitati_web.COD_UTENTE) INNER JOIN stato_pratica on elenco_pratiche.stato=stato_pratica.codice where elenco_pratiche.id_pratica = '%s'" %  id_pratica

        results=utils.runMappedQuery(self.getConnection(),strQuery)

        return results[0]
        

    security.declareProtected('Pax Use', 'listPratiche')        
    def listPratiche(self, REQUEST=None):
        "lista delle pratiche per l'utente loggato"

        session=REQUEST.SESSION
        
        idanag = session['idanag']
        
        strsql = "select pu.ID_PRATICA, ep.COD_INTERNO, ep.DESC_PRATICA, sp.DESCRIZ, pu.ABILITATO_WEB  from pratiche_utenti pu , elenco_pratiche ep , stato_pratica sp where pu.ID_ANAG='%s'  and pu.ID_PRATICA=ep.ID_PRATICA and ep.STATO=sp.CODICE" % idanag

        results=utils.runMappedQuery(self.getConnection(),strsql)
  
        return results



    security.declareProtected('Pax Use', 'documentiPratica')        
    def documentiPratica(self, REQUEST):
        "documenti allegati alla pratica"


        id_pratica=REQUEST['id_pratica']


        strsql = "select distinct\
        pratiche_documenti.ID_DOC,\
        pratiche_documenti.TIPO,\
        pratiche_documenti.DATA_PROTOCOLLO,\
        pratiche_documenti.OGGETTO,\
        pratiche_documenti.RIF_MITTENTE,\
        pratiche_documenti.DATA_MITTENTE,\
        pratiche_documenti.COD_AMM,\
        pratiche_documenti.COD_AREA\
        from pratiche_documenti, pratiche_utenti\
        where pratiche_documenti.ID_PRATICA=%s\
        and pratiche_utenti.ID_PRATICA=pratiche_documenti.ID_PRATICA" % id_pratica

        results=utils.runMappedQuery(self.getConnection(),strsql)
  
        return results
        
    security.declareProtected('Pax Use', 'validSession')        
    def validSession(self, REQUEST=None):
        "verifica lo stato della sessione"

        result=1
        
        if not REQUEST:
            result=0
        else:
            session=REQUEST.SESSION


            tf = getattr(self, 'temp_folder')

            if session.has_key('tnick'):  # aggiorniamo il ts
                now = time.time()
                ts = int(now)
                ua = time.strftime('%c (%A)', time.localtime(now))

                if ts > (session['ts'] + 20*60):
                    result=0
                else:
                    session['ts'] = ts

                try:
                    nickfile = getattr(tf, session['tnick'])
                    nickfile.manage_changeProperties( {'ts':ts, 'title':ua} )
                except:
                    tf.manage_addFile(session['tnick'], title=ua, content_type='text/plain', file='')
                    nickfile = getattr(tf, session['tnick'])
                    nickfile.manage_addProperty('ts', ts, 'int')   
                result=1

            else:
                result=0

        if result:
            return 1
        else:
            REQUEST.RESPONSE.redirect(self.pax_path()+'./?errormsg='+"Sessione scaduta")
            


    security.declareProtected('Pax Use', 'logout')            
    def logout(self, REQUEST=None, RESPONSE=None):
        "esegue il logout dal programma pratiche"

        session = REQUEST.SESSION
	redirect_to='index_html'

        tf = getattr(self, 'temp_folder')

        if session.has_key('tnick'):
            # se non esiste il file nick 
            try:
                nickfile = getattr(tf, session['tnick'])   # se c' il file lo prendo
            except:
                RESPONSE.redirect(self.pax_path()+redirect_to)

            try:
                tf.manage_delObjects(session['tnick'])      # e lo cancello
            except:
                tf = 'dumy'

            del session['tnick']

            RESPONSE.redirect(self.pax_path()+redirect_to)

        else:
            tf = 'dumy'

	RESPONSE.redirect(self.pax_path()+redirect_to)
        return 'ok'
        

    
    security.declareProtected('Pax Use', 'actionChangepass')            
    def actionChangepass(self, REQUEST=None, RESPONSE=None):
        "cambio password per l'utente"

        
        session = REQUEST.SESSION

        if self.validSession(REQUEST):  # utente gi loggato

            
            newpass = REQUEST.get('newpass', '')
            confnewpass = REQUEST.get('confnewpass', '')
            username = session.get('tnick', '')

            if self.UsersTool.changePassword(username,newpass,confnewpass):
                RESPONSE.redirect(self.pax_path()+'passwordchanged')
            else:
                RESPONSE.redirect(self.pax_path()+'changepass')
            
        else:
            RESPONSE.redirect(self.pax_path()+'./?errormsg='+"Utente o password sbagliati")


        if session.has_key('chpass'):
            del session['chpass']


        return


    security.declareProtected('Pax Use', 'loginFrom')            
    def loginFrom(self, REQUEST=None, RESPONSE=None):
        "like in Plone permits to login and to go directly to an url"
        session = REQUEST.SESSION

#        if self.validSession(session):  # utente gi loggato,  mauro: io lo tolgo
#             RESPONSE.redirect('home')
                
        if REQUEST == None:
            RESPONSE.redirect('./')

        result=self.UsersTool.checkUser(REQUEST,esterno=1)

        came_from=REQUEST['came_from']

        if not result:
            RESPONSE.redirect(self.pax_path()+'./?errormsg='+"Utente o password sbagliati")
        else:
            RESPONSE.redirect(self.pax_path()+came_from)
              
    security.declareProtected('Pax Use', 'actionLogin')            
    def actionLogin(self, REQUEST=None, RESPONSE=None):
        "autenticazione da login.pt"


#        if self.validSession(session):  # utente gi loggato,  mauro: io lo tolgo
#             RESPONSE.redirect('home')

        if REQUEST == None:
            RESPONSE.redirect('./')

        session = REQUEST.SESSION
            

        result=self.UsersTool.checkUser(REQUEST)

        if not result:
            RESPONSE.redirect(self.pax_path()+'./?errormsg='+"Utente o password sbagliati")
        else:
            if result==2:
                RESPONSE.redirect(self.pax_path()+'changepass')
            else:
                RESPONSE.redirect(self.pax_path()+'home')

        
         
        
    security.declareProtected('Pax Use', 'tributi')
    def tributi(self,comune,REQUEST=None, RESPONSE=None):
        "GEstione redirect verso i tributi."

        request = REQUEST
        RESPONSE =  request.RESPONSE
    
        session = request.SESSION
        
        nick=session.get('tnick', '')

        strsql = "select cf,newpassword from utenti where cf='%s'" % nick
        
        itemsc, resultsc = utils.runQuery(self.getConnection(),strsql)

        for record in resultsc:
            userid=record[0]
            password=record[1]

        if comune=='riva':
            RESPONSE.redirect('http://80.18.110.78/rivadgp/checkusr.pgm?password='+password+'&userid='+userid)
  
        if comune=='tenno':
            RESPONSE.redirect('http://80.18.110.78/tennop/checkusr.pgm?password='+password+'&userid='+userid)

        return
    

manage_addPraticheForm = DTMLFile('template/manage_addPraticheForm', globals())

def manage_addPraticheAction(self, id, connection, RESPONSE=None):
    "Add a Pratiche Application to a folder."
    ob = Pratiche(id)
    self._setObject(id, ob)
    ob = self._getOb(id)
    
    tf = MountedTemporaryFolder('temp_folder','Temporary Folder')
    ob._setObject('temp_folder', tf)

    # impostazione dei permessi
    ob.manage_permission('Pax Use', ['Manager','pax_webuser',], 1)
    ob.manage_permission('Pax Add Pratiche', ['Manager',], 1)

    ut = UsersTool('UsersTool')
    ob._setObject('UsersTool', ut)

    ob.manage_addProperty('connectionName', connection, 'string')

#    ob.manage_addProduct['UsersTool'].manage_addUsersTool(id='UsersTool')

    RESPONSE.redirect('manage_main')


