#!/usr/bin/python
#-----------------------------------------------------------------------------
# Name:        postacertificata.py
# Purpose:     Strumento di notifica nuova posta certificata
#
# Author:      Mauro Colorio <ced@comune.rivadelgarda.tn.it>
#
# Created:     2004/11/08
# RCS-ID:      $Id: postacertificata.py $
# Copyright:   (c) 2004
# Licence:     GPL
#-----------------------------------------------------------------------------

import imaplib
import email.Parser
import StringIO
import string
import smtplib
import MimeWriter
import mimetools

USER  = ''  #utente server posta certificata
PWD   = ''  #password utente posta certificata
FROM  = ''  #indirizzo mittente mail di segnalazione
TO    = ''  #indirizzo destinatario mail di segnalazione
IMAPS = ''  #server imaps posta certifcata
SMTP  = ''  #server smtp per l'invio della mail

def readmail():
    "Controlla se c'e' posta nuova sul server certificato"

    # controllo se c'e' posta...
    imaps = imaplib.IMAP4_SSL( IMAPS, 993 )
    imaps.login( USER, PWD )
    nr = int( imaps.select('INBOX')[1][0] )

    return nr

def sendmail():
    "Invia una mail di notifica"    

    writer = StringIO.StringIO()   
    msg = MimeWriter.MimeWriter(writer)

    msg.addheader( "From", "%s <%s>" % ( 'Postino Certificato', FROM ) )
    msg.addheader( "Reply-To", FROM )
    msg.addheader( "To", TO )
    msg.addheader( "Subject", "C'e' posta per voi" )
    
    boundary = mimetools.choose_boundary()

    dummy = msg.startmultipartbody( "mixed",boundary )
    dummy.write( "This is a multi-part message in MIME format.\n" )

    # parte testuale
    submsg = msg.nextpart()
    submsg.addheader( "Content-Transfer-Encoding", "7bit" )
    textpart = submsg.startbody( "text/plain; charset=us-ascii" )
    textpart.write( "%s\n" % 'Scaricare la posta dal server' )

    msg.lastpart()

    mimeout = writer.getvalue()

    outbox = smtplib.SMTP( SMTP )
    outbox.sendmail( FROM, TO, mimeout )
    outbox.quit()


    
checkmail = readmail()

if checkmail:
    sendmail()

print "Numero mail presenti sul server %d" % checkmail
