import os
import os.path
import sys
import string
import time
import re
import ConfigParser
#import MySQLdb
import psycopg
import xml.dom.minidom
from Ft.Xml.Xslt import Processor
from Ft.Xml import InputSource
from StringIO import StringIO
import sha
import MimeWriter
import mimetools
import multifile
import smtplib
import base64

INI_PATH='ipax.ini'

class SuperItem:
    def __init__(self, id, type="SuperItem"):
        "inizializzatore di SuperItem"

        self.id = id
        self.type = type
        self.received = False # True se ricevuto da Segnatura.xml
        config = get_config()
        
        #self.conn = psycopg.connect("dbname=pratiche user=postgres")
        l_args = [config.get('general', i) for i in ['connection_dbname',
                                                     'connection_user',
                                                     'connection_password'
                                                     ]]
        conn_str = 'dbname=%s user=%s password=%s' % tuple(l_args)
        self.conn = psycopg.connect(conn_str)
        self.cur = self.conn.cursor()
        self.attr = {}

        self.targetDir = config.get('general', 'target_dir')
        self.serverSMTP = config.get('general', 'smtp_server')
        self.CodiceAmministrazione = config.get('general', 'codice_amm')
        self.CodiceAOO = config.get('general', 'codice_aoo')
        self.denominazioneMittenteAOO = config.get('general', 'denominazione_aoo')
        self.IndirizzoTelematicoOrigine = config.get('general', 'sender_email')
        self.NoteIndirizzoTelematicoOrigine = config.get('general', 'sender_email_note')
        self.TipoIndirizzoTelematicoOrigine = 'smtp'
        self.IndirizzoTelematicoDestinazione = 'testipax@comune.rivadelgarda.tn.it' # un default?
        self.confermaRicezione = 'no' # un default?
        
        self.NumeroRegistrazione = ''
        now = time.localtime(time.time())
        self.DataRegistrazione = time.strftime("%Y-%m-%d" , now)
        self.OraRegistrazione = ''
        self.Oggetto = '%s: %s' % (self.type, self.NumeroRegistrazione)
        self.TestoDelMessaggio = ''
        self.attach = []
        self.riferimenti = []
        self.tipimime = []

        # e ora carichiamo i dati
        self.select_data()

        
    def set_attributes(self, newattrs):
        "set or update attribute in self.attr"
        self.attr.update(newattrs)
        self.create_xml()


    def set_from_element(self, e):
        "aggiorna gli attributi alla Segnatura.xml"
        d = {}
        for c in e.childNodes:
            if c.nodeType == 1:
                t = c.childNodes[0]
                if t.nodeType == 3: # e' un testo
                    txt =  t.data.strip()
                    d[c.tagName] = txt
        self.set_attributes(d)
        
        
    def custom_item_path(self):
        "ritorna il path dell'item"
        config = ConfigParser.ConfigParser()
        
        path = os.path.dirname( os.path.abspath( __file__ ) )
        
        config = get_config()

        try:
            item_path = config.get(self.type, 'path')
            
        except:
            item_path = path + '/' + self.type

        return item_path
        
    def select_data(self, sel='select.sql'):
        "legge i dati dallo storage"
    
        f = open( self.custom_item_path() + '/%s' % sel )
        
        sqllines = f.readlines()
        f.close()
        attributes = {}
        for l in sqllines:
            if self.id != None:
                sqlstr = string.replace(l, '@', str(self.id))
            else:
                sqlstr = l[:l.index('where')] + " where 0=1"
            self.cur.execute(sqlstr)
            rs = self.cur.fetchall()
            fields = [i[0] for i in self.cur.description]
            d = GetDictFromRs(rs, fields)
            if len(rs) > 0:
                attributes.update(d[0])
            else:
                attributes.update(dict(zip(fields, fields)))
        self.attr =  attributes
        self.create_xml()


    def insert_data(self, ins='insert.sql'):
        "scrive i dati dallo storage"
        
        # callback prima della insert
        self.pre_insert_callback()
        
        f = open( self.custom_item_path() + '/%s' % ins)
        sqllines = f.readlines()
        f.close()
        r = re.compile('@[^ ]+]')
        for l in sqllines:
            marks = r.findall(l)
            for m in marks:
                l = string.replace(l, str(m), str(self.attr[m[2:-1]]), 1)
            # occhio!
            print l
            return
            # occhio!
            self.cur.execute(l)

            if l.split(' ')[0] == 'select':
                rs = self.cur.fetchall()
                if len(rs) > 0:
                    fields = [i[0] for i in self.cur.description]
                    d = GetDictFromRs(rs, fields)
                    self.attr.update(d[0])
                    self.NumeroRegistrazione = self.attr['id']

            self.cur.execute('COMMIT')

        # callback dopo la insert
        self.post_insert_callback()
        

    def pre_insert_callback(self):
        # da definire negli oggetti figli
        return
    

    def post_insert_callback(self):
        # da definire negli oggetti figli
        return
    
    
    def get_dom(self, onlyroot=False):
        "restituisce l'oggetto dom"
        DOM = xml.dom.minidom.Document()
        root = DOM.createElement('SuperItem')
        root.setAttribute("id", str(self.id))
        root.setAttribute("type", str(self.type))
        DOM.appendChild(root)
        for ka in self.attr.keys():
            child = DOM.createElement(ka)
            text = DOM.createTextNode(str(self.attr[ka]))
            child.appendChild(text)
            root.appendChild(child)
        if onlyroot:
            return root
        else:
            return DOM
    

    def create_xml(self):
        "create xml"
        DOM = self.get_dom()
        self.xml = DOM.toxml()


    def send(self):
        "invia l'oggetto"
        xmlout = self.get_segnature()
        
        # xml
    
        f = open(os.path.join(self.targetDir,self.NumeroRegistrazione + '.xml'), 'w')
        f.write(xmlout)
        f.flush()
        f.close()
        
        # impronta
        impr = sha.new(xmlout).hexdigest()
        f = open(os.path.join(self.targetDir, self.NumeroRegistrazione + '.sha'), 'w')
        f.write(impr)
        f.flush()
        f.close()

        # busta mime
        mimeout = self.get_mime(xmlout, impr)
        f = open(os.path.join(self.targetDir, self.NumeroRegistrazione + '.mime'), 'w')
        f.write(mimeout)
        f.flush()
        f.close()
        
        outbox = smtplib.SMTP(self.serverSMTP)
        outbox.sendmail(self.IndirizzoTelematicoOrigine, [self.IndirizzoTelematicoDestinazione], mimeout)
        outbox.quit()
        
        #res = "Debug: \n\n%s\n\n%s\n" % (p.attach, p.tipimime)
        #print res
        

    def get_mime(self, xml, impr):
        "genera un messaggio MIME"

        writer = StringIO()
        fxml = open(os.path.join(self.targetDir, self.NumeroRegistrazione + '.xml'), 'r')
        msg = MimeWriter.MimeWriter(writer)

        msg.addheader("From", "%s <%s>" % (self.CodiceAmministrazione, self.IndirizzoTelematicoOrigine) )
        msg.addheader("Reply-To", self.IndirizzoTelematicoOrigine)
        msg.addheader("To", self.IndirizzoTelematicoDestinazione)
        msg.addheader("Subject", "Busta SMTP/MIME")

        boundary = mimetools.choose_boundary()

        dummy = msg.startmultipartbody("mixed",boundary)
        dummy.write("This is a multi-part message in MIME format.\n")

        # parte testuale
        submsg = msg.nextpart()
        submsg.addheader("Content-Transfer-Encoding", "7bit")
        textpart = submsg.startbody("text/plain; charset=us-ascii")
        textpart.write("%s\n" % self.TestoDelMessaggio)


        # segnatura XML
        submsg2 = msg.nextpart()
        submsg2.addheader("Content-Transfer-Encoding", "base64")
        submsg2.addheader("Content-Disposition", "inline;\n\tfilename=\"Segnatura.xml\"")
        xmlpart = submsg2.startbody("application/x-unknow-content-type-xml_auto_file;\n\tname=\"Segnatura.xml\"")
        mimetools.encode(fxml , writer, "base64")

        # testo allegato (es. 00000001.txt)
        #if self.TestoAllegato != "":
        #    a = "%s.txt" % self.NumeroRegistrazione
        #    submsg3 = msg.nextpart()
        #    submsg3.addheader("Content-Transfer-Encoding", "base64")
        #    submsg3.addheader("Content-Disposition", "inline;\n\tfilename=\"%s\"" % a)
        #    apppart = submsg3.startbody("%s\n\tname=\"%s\"" % ('plain/txt', a))
        #    fatt = open(os.path.join(self.targetDir, a), 'rb')
        #    mimetools.encode(fatt, writer, "base64")
        #    fatt.close()

 
        # allegati
        for n in range(len(self.attach)):
            a = self.attach[n]
            submsg3 = msg.nextpart()
            submsg3.addheader("Content-Transfer-Encoding", "base64")
            submsg3.addheader("Content-Disposition", "inline;\n\tfilename=\"%s\"" % a)
            t = self.tipimime[n]
            apppart = submsg3.startbody("%s\n\tname=\"%s\"" % (t, a))
            fatt = open(os.path.join(self.targetDir, a), 'rb')
            mimetools.encode(fatt, writer, "base64")
            fatt.close()
 
        # chiusura
        msg.lastpart()
        fxml.close()

        mimeout = writer.getvalue()

        return mimeout

    
    def store_data(self):
        ""
        
        
    def get_id(self):
        ""
        return self.id


    def get_type(self):
        ""
        return self.type


    def get_attr(self):
        ""
        return self.attr


    def get_xml(self):
        ""
        return self.xml


    def get_ascii(self):
        ""
        strout = ""
        for k in self.attr.keys():
            strout += str(self.attr[k]) + "|"

        return strout[:-1]

    
    def get_xsltransform(self, transform):
        ""
        f = open('%s_%s.xsl' % (self.type, transform))
        xsl = ''
        lines = f.readlines()
        f.close()
        for l in lines:
            xsl += l
        t = InputSource.DefaultFactory.fromString(xsl, xsl)
        s = InputSource.DefaultFactory.fromString(self.xml, self.xml)
        p = Processor.Processor()
        p.appendStylesheet(t)
        result = p.run(s)
        return result


    def get_segnature(self):
        "segnatura per l'interoperabilita'"

        DOM = xml.dom.minidom.Document()
        
        # Originale:
        # <!ELEMENT Segnatura (Intestazione, Riferimenti?, Descrizione?)>
        # <!ATTLIST Segnatura
        #         versione NMTOKEN #FIXED "%dataPubblicazione;"
        #         xml:lang NMTOKEN #FIXED "it"
        # >
        #
        # Attuale:
        # <!ELEMENT Segnatura (Intestazione, Descrizione?)>
        # <!ATTLIST Segnatura
        #         versione NMTOKEN #FIXED "%dataPubblicazione;"
        #         xml:lang NMTOKEN #FIXED "it"
        # >
        SegnaturaElement = DOM.createElement("Segnatura")
        SegnaturaElement.setAttribute("versione", "2000-10-18")
        SegnaturaElement.setAttribute("lang", "it")
        DOM.appendChild(SegnaturaElement)

        # Originale:
        # <!ELEMENT Intestazione (Identificatore, PrimaRegistrazione?, OraRegistrazione?,
        #                         Origine, Destinazione+, PerConoscenza*, Risposta?, Riservato?,
        #                         InterventoOperatore?, RiferimentoDocumentiCartacei?, Oggetto,
        #                         Classifica*, Note?)>    
        #
        # Attuale:
        # <!ELEMENT Intestazione (Identificatore, OraRegistrazione?,
        #                         Origine, Destinazione, Oggetto)>
        IntestazioneElement = DOM.createElement("Intestazione")
        SegnaturaElement.appendChild(IntestazioneElement)

        # <!ELEMENT Identificatore (CodiceAmministrazione, CodiceAOO, NumeroRegistrazione, DataRegistrazione)>
        IdentificatoreElement = DOM.createElement("Identificatore")
        IntestazioneElement.appendChild(IdentificatoreElement)

        # <!ELEMENT CodiceAmministrazione (#PCDATA)>
        CodiceAmministrazioneElement = DOM.createElement("CodiceAmministrazione")
        IdentificatoreElement.appendChild(CodiceAmministrazioneElement)
        CodiceAmministrazioneText = DOM.createTextNode(self.CodiceAmministrazione)
        CodiceAmministrazioneElement.appendChild(CodiceAmministrazioneText)

        # <!ELEMENT CodiceAOO (#PCDATA)>
        CodiceAOOElement = DOM.createElement("CodiceAOO")
        IdentificatoreElement.appendChild(CodiceAOOElement)
        CodiceAOOText = DOM.createTextNode(self.CodiceAOO)
        CodiceAOOElement.appendChild(CodiceAOOText)

        # <!ELEMENT NumeroRegistrazione (#PCDATA)>
        NumeroRegistrazioneElement = DOM.createElement("NumeroRegistrazione")
        IdentificatoreElement.appendChild(NumeroRegistrazioneElement)
        NumeroRegistrazioneText = DOM.createTextNode(self.NumeroRegistrazione)
        NumeroRegistrazioneElement.appendChild(NumeroRegistrazioneText)

        # <!ELEMENT DataRegistrazione (#PCDATA)>
        DataRegistrazioneElement = DOM.createElement("DataRegistrazione")
        IdentificatoreElement.appendChild(DataRegistrazioneElement)
        DataRegistrazioneText = DOM.createTextNode(self.DataRegistrazione)
        DataRegistrazioneElement.appendChild(DataRegistrazioneText)
            
        # <!ELEMENT PrimaRegistrazione (Identificatore)>  non ancora trattata!!
        
        # Originale:
        # <!ELEMENT OraRegistrazione (#PCDATA)>
        # <!ATTLIST OraRegistrazione
        #         tempo (locale | rupa | CDATA) "locale"
        # >
        #
        # Attuale:
        # <!ELEMENT OraRegistrazione (#PCDATA)>
        # <!ATTLIST OraRegistrazione
        #         tempo  #FIXED "locale"
        # >        
        if self.OraRegistrazione != "":
            OraRegistrazioneElement = DOM.createElement("OraRegistrazione")
            OraRegistrazioneElement.setAttribute("tempo", "locale")
            IntestazioneElement.appendChild(OraRegistrazioneElement)
            OraRegistrazioneText = DOM.createTextNode(self.OraRegistrazione)
            OraRegistrazioneElement.appendChild(OraRegistrazioneText)
        
        
        # <!ELEMENT Origine (IndirizzoTelematico, Mittente)>
        OrigineElement = DOM.createElement("Origine")
        IntestazioneElement.appendChild(OrigineElement)

        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo (smtp | url | CDATA) "smtp"
        #         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        OrigineElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode(self.IndirizzoTelematicoOrigine)
        IndirizzoTelematicoElement.setAttribute("tipo", self.TipoIndirizzoTelematicoOrigine)
        if len(self.NoteIndirizzoTelematicoOrigine) > 0:
            IndirizzoTelematicoElement.setAttribute("note", self.NoteIndirizzoTelematicoOrigine)
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)

        # <!ELEMENT Mittente (Amministrazione, AOO)>
        MittenteElement = DOM.createElement("Mittente")
        OrigineElement.appendChild(MittenteElement)

        # Originale:
        # <!ELEMENT Amministrazione (Denominazione, CodiceAmministrazione?,
        #  (UnitaOrganizzativa | (Persona*, IndirizzoPostale, IndirizzoTelematico*, Telefono*, Fax*)))?>
        #
        # Attuale:
        # <!ELEMENT Amministrazione>
        AmministrazioneElement = DOM.createElement("Amministrazione")
        MittenteElement.appendChild(AmministrazioneElement)

        # Originale:
        # <!ELEMENT AOO (Denominazione, CodiceAOO?)>
        #
        # Attuale:
        # <!ELEMENT AOO (Denominazione)>
        AOOElement = DOM.createElement("AOO")
        MittenteElement.appendChild(AOOElement)

        # <!ELEMENT Denominazione (#PCDATA)>
        DenominazioneElement = DOM.createElement("Denominazione")
        AOOElement.appendChild(DenominazioneElement)
        DenominazioneText = DOM.createTextNode(self.denominazioneMittenteAOO)
        DenominazioneElement.appendChild(DenominazioneText)
            
        # Originale:
        # <!ELEMENT Destinazione (IndirizzoTelematico, Destinatario*)>
        # <!ATTLIST Destinazione
        #         confermaRicezione (si | no) "no"
        # >
        #
        # Attuale:
        # <!ELEMENT Destinazione (IndirizzoTelematico)>
        # <!ATTLIST Destinazione
        #         confermaRicezione (si | no) "no"
        # >
        DestinazioneElement = DOM.createElement("Destinazione")
        DestinazioneElement.setAttribute("confermaRicezione", self.confermaRicezione)
        IntestazioneElement.appendChild(DestinazioneElement)

        # Originale:
        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo (smtp | url | CDATA) "smtp"
        #         note CDATA #IMPLIED
        # >
        #
        # Attuale:
        # <!ELEMENT IndirizzoTelematico (#PCDATA)>
        # <!ATTLIST IndirizzoTelematico
        #         tipo "smtp"
        #         note CDATA #IMPLIED
        # >
        IndirizzoTelematicoElement = DOM.createElement("IndirizzoTelematico")
        IndirizzoTelematicoElement.setAttribute("tipo", "smtp")
        DestinazioneElement.appendChild(IndirizzoTelematicoElement)
        IndirizzoTelematicoText = DOM.createTextNode(self.IndirizzoTelematicoDestinazione)
        IndirizzoTelematicoElement.appendChild(IndirizzoTelematicoText)

        # <!ELEMENT Oggetto (#PCDATA)>
        OggettoElement = DOM.createElement("Oggetto")
        IntestazioneElement.appendChild(OggettoElement)
        OggettoText = DOM.createTextNode(self.attr['Oggetto'])
        OggettoElement.appendChild(OggettoText)

        # Originale:
        # <!ELEMENT Descrizione ((Documento | TestoDelMessaggio), Allegati?, Note?)>
        #
        # Attuale:
        # <!ELEMENT Descrizione (Documento | TestoDelMessaggio)>
        if len(self.TestoDelMessaggio) > 0 or len(self.attach) > 0:   # e' opzionale!
            DescrizioneElement = DOM.createElement("Descrizione")
            SegnaturaElement.appendChild(DescrizioneElement)
        
            # <!ELEMENT TestoDelMessaggio EMPTY>
            # <!ATTLIST TestoDelMessaggio
            #         id CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento NMTOKEN #FIXED "MIME"
            # >
            # e' il testo del messaggio mime
            if len(self.TestoDelMessaggio) > 0: 
                TestoDelMessaggioElement = DOM.createElement("TestoDelMessaggio")
                TestoDelMessaggioElement.setAttribute("id", "%s.txt" % self.NumeroRegistrazione) #!
                TestoDelMessaggioElement.setAttribute("tipoMIME", "text/plain") #!
                TestoDelMessaggioElement.setAttribute("tipoRiferimento", "MIME") #!
                DescrizioneElement.appendChild(TestoDelMessaggioElement)

            # Originale:
            # <!ELEMENT Documento ((URI, Impronta?)?, TitoloDocumento?, PrimaRegistrazione?,
            #         TipoDocumento?, Oggetto?, Classifica*, NumeroPagine?, Note?)>
            # <!ATTLIST Documento
            #         id ID #IMPLIED
            #         rife IDREF #IMPLIED
            #         nome CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento (MIME | informatico | cartaceo) "MIME"
            # >
            #
            # Attuale:
            # <!ELEMENT Documento>
            # <!ATTLIST Documento
            #         id ID #IMPLIED
            #         nome CDATA #IMPLIED
            #         tipoMIME CDATA #IMPLIED
            #         tipoRiferimento NMTOKEN #FIXED "MIME"
            # >
            
            else:
                Documento = DOM.createElement("Documento")
                if self.riferimenti[0] == "MIME" or len(self.riferimenti[0]) == 0:
                    Documento.setAttribute("tipoRiferimento","MIME") 
                    Documento.setAttribute("id", self.attach[0])        # utilizzo opzionale come id univoco nell'xml
                    Documento.setAttribute("nome", self.attach[0])      # e' il filename di Content-Disposition
                    if len(self.tipimime[0]) > 0:
                        Documento.setAttribute("tipoMIME", self.tipimime[0])
                    else:
                        ext = self.attach[0].split('.')[-1]
                        tipomime = dizmime.get(ext, ext) 
                        Documento.setAttribute("tipoMIME", "%s" % tipomime)
                elif self.riferimenti[0] == "informatico":
                    Documento.setAttribute("tipoRiferimento","informatico") 
                    Documento.setAttribute("id", self.attach[0])   # utilizzo opzionale come id univoco nell'xml
                    Documento.setAttribute("tipoRiferimento","informatico")
                    if len(self.tipimime[0]) > 0:
                        Documento.setAttribute("tipoMIME", self.tipimime[0])
                    else:
                        tipomime = "text/plain" # che tipo mime per i link ??
                        Documento.setAttribute("tipoMIME", "%s" % tipomime)
                elif self.riferimenti[0] == "cartaceo":
                    Documento.setAttribute("tipoRiferimento","cartaceo")
                    Documento.setAttribute("id", self.attach[0])   # identif. documento cartaceo (occhio a PrimaRegistrazione!!)
                DescrizioneElement.appendChild(Documento)

        # inserimento dello xml specifico dell'oggetto
        rootobj = self.get_dom(True)
        SegnaturaElement.appendChild(rootobj)
        
        # questo e' il metodo per aggirare il fatto che Document.toxml non scrive l'encoding
        writer = StringIO()
        writer.write('<?xml version="1.0" encoding="UTF-8" ?>\n')
        writer.write('<!DOCTYPE Segnatura SYSTEM "Segnatura.dtd">\n')
        for node in DOM.childNodes:
            node.writexml(writer, "", "\t", "\n")
        xmlout = writer.getvalue()

        return xmlout

        

# utility
def GetDictFromRs(rs, fields):
    return map(lambda r: dict(map(lambda x,y: (x, r[y]), fields, range(len(fields)))), rs)

def get_config():
    "returns config file"
    
    config = ConfigParser.ConfigParser()    
    path = os.path.dirname( os.path.abspath( __file__ ) )

    config.read( path + '/' + INI_PATH )
    
    return config 

