/*  pdnmesh - a 2D finite element solver
    Copyright (c) 2001-2004 Sarod Yatawatta <sarod@users.sf.net>  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  $Id: lexer.l,v 1.11 2004/03/03 01:32:49 sarod Exp $
*/
/* lexical analyser */
D [0-9]

%{
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include "types.h"
#include "parser.h"


#ifdef DEBUG
	int yylineno;
#endif
%}

%%
[a-z]	{ /* variable only x, y, p possible ( p for potential )*/
yylval.sym = *yytext - 'a'; 

#ifdef DEBUG
printf("lexer:variable detect %s\n", yytext);
#endif
return( VARIABLE );
}
({D}+|({D}*"."{D}+)) 	{ /* floating point */
			yylval.val = strtod(yytext,0); 

		#ifdef DEBUG
			printf("lexer:double detect "MDF"\n",yylval.val);
		#endif
			return( CONSTANT );
			}
"PI"					{ /* pi */
			yylval.val = 3.14159265358979323846;
		#ifdef DEBUG
			printf("lexer:pi detect "MDF"\n",yylval.val);
		#endif
			return( CONSTANT );
			}
"E"					{ /* e */
			yylval.val = 2.7182818284590452354;
		#ifdef DEBUG
			printf("lexer:e detect "MDF"\n",yylval.val);
		#endif
			return( CONSTANT );
			}
[-()+*/^;]	{ /* operators */

		#ifdef DEBUG
			printf("lexer:operator detect %s\n", yytext);
		#endif
			return( *yytext );

		}
"sin"	 	{   /* sin */

		#ifdef DEBUG
			printf("lexer:SIN detect %s\n", yytext);
		#endif
		return SIN; /* sin() */

		}
"cos"	 	{   /* cos */

		#ifdef DEBUG
			printf("lexer:COS detect %s\n", yytext);
		#endif
		return COS; /* cos() */

		}
"log"	 	{   /* log */

		#ifdef DEBUG
			printf("lexer:LOG detect %s\n", yytext);
		#endif
		return LOG; /* log() */

		}
"step"	{ /* unit step */

		#ifdef DEBUG
			printf("lexer:STEP detect %s\n", yytext);
		#endif
		return STEP; /* step() */

		}
"abs"	{ /* absolute value */

		#ifdef DEBUG
			printf("lexer:FABS detect %s\n", yytext);
		#endif
		return FABS; /* abs() */

		}
[ \t\n+]	{ /* eatup whitespace */ 
				#ifdef DEBUG
					printf("lexer: space\n");
				#endif
				
				; /* nothing */
			}
.	   {  /* any other thing */
		#ifdef DEBUG
		yyerror("unknown at %d %s", yylineno, yytext);
		#endif
		#ifndef DEBUG
		yyerror("unknown ");yyerror(yytext);
		#endif
		}

%%

int yywrap(void) {
	return(1);
}

/* parses string for equation */
/* and store values in x,y arrays */
int 
equation_parse(char * string)
{
	yy_switch_to_buffer(yy_scan_string(string));
#ifdef DEBUG
	printf("parsing %s\n",string);
#endif

	return(yyparse());
}
