/*  pdnmesh - a 2D finite element solver
    Copyright (c) 2001-2004 Sarod Yatawatta <sarod@users.sf.net>  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  $Id: output.c,v 1.6 2004/07/24 06:47:15 sarod Exp $
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gtk/gtkgl.h>
#include <gdk/gdkkeysyms.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "types.h"

/* output choice */
typedef enum {OUT_CONT, OUT_CONT_COLOR, OUT_CONT_COLOR_LEGEND, OUT_GRAD, OUT_MESH, OUT_MESH_EPS} outfile_type;
outfile_type output_file_option=0;

static void
select_output_choice(GtkWidget *button, gpointer data)
{
	output_file_option=GPOINTER_TO_INT(data);
}

static void 
store_output_filename(GtkWidget *widget, gpointer data)
{
	GtkWidget *file_selector=(GtkWidget*)data;
	const char *tempnm;
	tempnm=gtk_file_selection_get_filename(GTK_FILE_SELECTION(file_selector));

	if ( tempnm ) {
		switch (output_file_option ) {
				case OUT_CONT:
           print_contour_all((char*)tempnm,0);
					 break;
        case OUT_CONT_COLOR:
           print_contour_all((char*)tempnm,1);
					 break;
        case OUT_CONT_COLOR_LEGEND:
           print_contour_all((char*)tempnm,2);
					 break;

	case OUT_GRAD:
           print_gradient((char*)tempnm);
           break;
	case OUT_MESH_EPS:
           print_mesh_eps((char*)tempnm);
	   break;
        case OUT_MESH:
	   print_mesh_ascii((char*)tempnm);
	   break;
	default:
           break;
	  }
	}
}

static void
save_output_file(GtkWidget *widget, gpointer data)
{
 GtkWidget *file_selector;


 gtk_widget_destroy(GTK_WIDGET(data));
 /* get file name */
 file_selector=gtk_file_selection_new("Select Output file");
 g_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
										"clicked",
										G_CALLBACK(store_output_filename),
										(gpointer)file_selector);
 g_signal_connect_swapped(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->ok_button),
								 "clicked",
								 G_CALLBACK(gtk_widget_destroy),
								 (gpointer)file_selector);
 g_signal_connect_swapped(GTK_OBJECT(GTK_FILE_SELECTION(file_selector)->cancel_button),
								 "clicked",
								 G_CALLBACK(gtk_widget_destroy),
								 (gpointer)file_selector);
 gtk_widget_show(file_selector);

}

static void
close_output_dialog(GtkWidget *widget, gpointer data)
{
 gtk_widget_destroy(GTK_WIDGET(data));
}

void
generate_output_files(void)
{
  GtkWidget *window,*box1,*box2,*button0,*button1,*separator;

	window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(window),"delete_event",
									G_CALLBACK(gtk_main_quit),NULL);
	gtk_window_set_title(GTK_WINDOW(window),"Select Output");
  gtk_window_set_modal(GTK_WINDOW(window),FALSE);

	box1=gtk_vbox_new(FALSE,0);
	gtk_container_add(GTK_CONTAINER(window),box1);
	gtk_widget_show(box1);

	box2=gtk_hbox_new(FALSE,10);
	gtk_container_set_border_width(GTK_CONTAINER(box2),10);
	gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
	gtk_widget_show(box2);

	button0 = gtk_radio_button_new_with_label (NULL,"Contour EPS");
  if ( output_file_option == OUT_CONT) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button0),TRUE); }
	gtk_box_pack_start (GTK_BOX (box2), button0, TRUE, TRUE, 0);
	gtk_widget_show(button0);
	g_signal_connect(G_OBJECT(button0),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_CONT));

	
  box2=gtk_hbox_new(FALSE,10);
	gtk_container_set_border_width(GTK_CONTAINER(box2),10);
	gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
	gtk_widget_show(box2);
	button1 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(button0),"Contour Color EPS");
  if ( output_file_option == OUT_CONT_COLOR ) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),TRUE); }
	gtk_box_pack_start(GTK_BOX(box2), button1, TRUE, TRUE, 0);
	gtk_widget_show (button1);
	g_signal_connect(G_OBJECT(button1),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_CONT_COLOR));

  box2=gtk_hbox_new(FALSE,10);
	gtk_container_set_border_width(GTK_CONTAINER(box2),10);
	gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
	gtk_widget_show(box2);
	button1 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(button0),"Contour Color+Legend EPS");
  if ( output_file_option == OUT_CONT_COLOR_LEGEND ) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),TRUE); }
	gtk_box_pack_start(GTK_BOX(box2), button1, TRUE, TRUE, 0);
	gtk_widget_show (button1);
	g_signal_connect(G_OBJECT(button1),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_CONT_COLOR_LEGEND));


	box2=gtk_hbox_new(FALSE,10);
	gtk_container_set_border_width(GTK_CONTAINER(box2),10);
	gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
	gtk_widget_show(box2);
	button1 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(button0),"Gradient EPS");
  if ( output_file_option == OUT_GRAD) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),TRUE); }
	gtk_box_pack_start(GTK_BOX(box2), button1, TRUE, TRUE, 0);
	gtk_widget_show (button1);
	g_signal_connect(G_OBJECT(button1),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_GRAD));



  box2=gtk_hbox_new(FALSE,10);
  gtk_container_set_border_width(GTK_CONTAINER(box2),10);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_widget_show(box2);
	button1 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(button0),"Mesh EPS");
  if ( output_file_option == OUT_MESH_EPS ) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),TRUE); }
	gtk_box_pack_start(GTK_BOX(box2), button1, TRUE, TRUE, 0);
	gtk_widget_show (button1);
	g_signal_connect(G_OBJECT(button1),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_MESH_EPS));


	box2=gtk_hbox_new(FALSE,10);
  gtk_container_set_border_width(GTK_CONTAINER(box2),10);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_widget_show(box2);
	button1 = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(button0),"Mesh ASCII");
  if ( output_file_option == OUT_MESH) { gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(button1),TRUE); }
	gtk_box_pack_start(GTK_BOX(box2), button1, TRUE, TRUE, 0);
	gtk_widget_show (button1);
	g_signal_connect(G_OBJECT(button1),"toggled",
						G_CALLBACK(select_output_choice),GINT_TO_POINTER(OUT_MESH));

 /* seperator */
 separator = gtk_hseparator_new();
 gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);
 gtk_widget_show (separator);

 /* buttons */
 box2=gtk_hbox_new(FALSE,10);
  gtk_container_set_border_width(GTK_CONTAINER(box2),10);
  gtk_box_pack_start(GTK_BOX(box1),box2,TRUE,TRUE,0);
  gtk_widget_show(box2);

	button0=gtk_button_new_with_label("OK");
	g_signal_connect(G_OBJECT(button0),"clicked",
						G_CALLBACK(save_output_file),
					window);

	gtk_box_pack_start(GTK_BOX(box2),button0,TRUE,TRUE,0);
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button0);
	gtk_widget_show(button0);

	button0=gtk_button_new_with_label("Cancel");
	g_signal_connect(G_OBJECT(button0),"clicked",
						G_CALLBACK(close_output_dialog),
					window);

	gtk_box_pack_start(GTK_BOX(box2),button0,TRUE,TRUE,0);
	gtk_widget_show(button0);

	gtk_widget_show(window);

}
