// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#ifndef __IN_IMPL_H
#define __IN_IMPL_H

#include "in.h"

//=== InputImpl (abstract base class) ======================================
class InputImpl: public Input {

	protected:

	string	m_option_key;

		InputImpl (const string& option_key);

	void Parse (const string& expr, const ptime& timestamp, bool verbose, Database::CollectionsItems& items) const throw (Xception);
};

//=== FileInputImpl ========================================================
class FileInputImpl: public InputImpl {

	protected:

	string	m_vector_key;

		FileInputImpl (const string& option_key, const string& vector_key);

	virtual void ProcessFile (const Config& config, Database& database, ifstream& ifs, Database::CollectionsItems& items) const throw (Xception) =0;

	public:

	virtual	void Do (const Config& config, Database& database) const throw (Xception);
};

//=== Pop3MailClient =======================================================
class Pop3MailClient: public InputImpl {

	public:

		Pop3MailClient (const string& option_key);

	virtual	void Do (const Config& config, Database& database) const throw (Xception);
};

//=== CmdLineExpr ==========================================================
class CmdLineExpr: public InputImpl {

	public:

		CmdLineExpr ();

	virtual	void Do (const Config& config, Database& database) const throw (Xception);
};

//=== TXTFile ==============================================================
class TXTFile: public FileInputImpl {

	public:

		TXTFile (const string& option_key);

	protected:

	virtual void ProcessFile (const Config& config, Database& database, ifstream& ifs, Database::CollectionsItems& items) const throw (Xception);
};

//=== CSVFile ==============================================================
class CSVFile: public FileInputImpl {

	public:

		CSVFile (const string& option_key);

	protected:

	virtual void ProcessFile (const Config& config, Database& database, ifstream& ifs, Database::CollectionsItems& items) const throw (Xception);
};

//=== XMLFile ==============================================================
class XMLFile: public FileInputImpl {

	public:

		XMLFile (const string& option_key);

	protected:

	virtual void ProcessFile (const Config& config, Database& database, ifstream& ifs, Database::CollectionsItems& items) const throw (Xception);
};

//=== InputInteractive =====================================================
class InputInteractive: public InputImpl {

	public:

		InputInteractive (const string& option_key);

	virtual	void Do (const Config& config, Database& database) const throw (Xception);
};

#endif
