// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "../libpdrx/common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "../libpdrx/xception.h"
#include "../libpdrx/config.h"
#include "db.h"
#include "in_impl.h"

//=== TXTFile ==============================================================
TXTFile::TXTFile (const string& option_key)
	: FileInputImpl(option_key, "txt")
{
}

void TXTFile::ProcessFile (const Config& config, Database& database, ifstream& ifs, Database::CollectionsItems& items) const throw (Xception)
{
	// get configuration data
	Poco::TextEncoding* pEncoding = NULL;
	if (m_option_key.empty())
		pEncoding = &NativeEncoding();
	else
		pEncoding = &SpecificEncoding(config.GetStringOption(m_option_key + ".encoding"));

	const ptime& timestamp = config.GetNow();

	// parse line by line
	Database::Collections collections;
	database.GetCollections(collections);

	string line;
	while (getline(ifs, line).good())
	{
		trim(line);
		line = Decode(line, *pEncoding);

		// ignore an empty line
		if (line.empty())
			continue;

		// ignore a comment line
		if (line[0] == '#')
			continue;

		// otherwise parse a data line
		Parse(line, timestamp, false, collections, items);
	}
}
