// This file is part of the pdr/pdx project.
// Copyright (C) 2010 Torsten Mueller, Bern, Switzerland
//
// This program is free software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as
// published by the Free Software Foundation, either version 2 of the
// License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.

#include "../libpdrx/common.h"

using namespace std;
using namespace boost;
using namespace boost::posix_time;
using namespace boost::gregorian;
using namespace boost::program_options;

#include "../libpdrx/xception.h"
#include "../libpdrx/conversions.h"
#include "../libpdrx/config.h"
#include "db.h"
#include "in_impl.h"

//=== CmdLineExpr ==========================================================
CmdLineExpr::CmdLineExpr ()
	: InputImpl("")
{
}

void CmdLineExpr::Do (const Config& config, Database& database) const throw (Xception)
{
	// get configuration data
	const vector<string>& exprs = config.GetVectorOption("expression"); // get expressions from command line
	if (exprs.empty())
		return;

	bool verbose = config.GetBoolOption("verbose");
	if (verbose)
		encoded::cout << (format("evaluating expression%s") % ((exprs.size() == 1) ? "" : "s")).str() << endl;

	// in the case of command line expressions we don't want to process
	// expression by expression, we want the whole command line to be
	// processed successfully or not, so we make one single transaction
	// for all

	// build CollectionsItems
	Database::CollectionsItems items;
	{
		Database::Collections collections;
		database.GetCollections(collections);

		Poco::TextEncoding& encoding = NativeEncoding();

		const ptime& timestamp = config.GetNow();
		foreach (string expr, exprs)
		{
			try
			{
				trim(expr);
				if (!expr.empty() && expr[0] == '=')
				expr.erase(0, 1);

				if (expr.empty())
					continue;

				Parse(Decode(expr, encoding), timestamp, verbose, collections, items);
			}
			catch (const Xception& x)
			{
				encoded::cerr << x.Message(Xception::brief) << endl;
			}
		}
	}

	// add the contents of all expressions in a single
	// transaction to the database
	database.AddCollectionsItems(items);
}
