/*
 * pdscmfunctions.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdscmfunctions.h
 *  \brief Archivo de definiciónn de funciones extras para la biblioteca PDSCM.
 *
 *  Aquí se tienen definidas algunas funciones extras para la biblioteca PDSCM.
 */

#ifndef __PDSCMFUNCTIONS_H__
#define __PDSCMFUNCTIONS_H__


#ifdef __cplusplus
extern "C" {
#endif 

#include  <pds/pdscmglobal.h>
#include  <pds/pdsvector.h>
#include  <pds/pdsbvector.h>

#ifndef TRUE
	#define TRUE 1
#endif

#ifndef FALSE
	#define FALSE 0
#endif

/** \defgroup PdsCmFunctionsGroup Funciones extras de la biblioteca PdsCm.
 * @{
 */


/** \fn int pds_vector_hard_decision(PdsBVector *BVector1,const PdsVector *Vector2, PdsCmReal D)
 *  \brief Aplica una hard decision sobre el vector Vector2 con limear en D y lo carga en BVector1.
 *  Todo valor mayor o igual a D es considerado un bit 1, caso contrario se considera un bit 0.
 *  \param[in,out] BVector1 Es uno de los vectores a comparar.
 *  \param[in] Vector2 Es uno de los vectores a comparar.
 *  \param[in] D Es el limear para la hard decision.
 *  \return TRUE si todo fue bien, o FALSE sino. Ejem: BVector1==NULL o Vector2==NULL.
 *  \ingroup PdsCmFunctionsGroup
 */
int pds_vector_hard_decision(PdsBVector *BVector1,const PdsVector *Vector2, PdsCmReal D);

/**
 * @}
 */


#ifdef __cplusplus
}
#endif 

#endif /* __PDSCMFUNCTIONS_H__ */
