/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog1.c
 *  \author Fernando Pujaico Rivera
 *  \date 07-05-2011
 *  \brief Programa para el testeo de un canal BIAWGN.
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdscm.h>

int main(int argc, char** argv)
{	
	PdsBVector *X=NULL;
	PdsVector *Y=NULL;
	PdsBiAwgn *Channel=NULL;

	X=pds_bvector_new(20);
	Y=pds_vector_new(20);
	Channel=pds_biawgn_new(2.0,0.3);
	printf("BIAWGN\nA    : 2.0\nSigma: 0.3\n\n");

	pds_bvector_init_rand(X,0.5);

	pds_biawgn_evaluate(Channel,X,Y);

	printf("Input :\n");
	pds_bvector_printf(X);
	printf("Output:\n");
	pds_vector_printf(Y);
	
	pds_biawgn_free(Channel);
	pds_vector_free(Y);
	pds_bvector_free(X);

	printf("\n");

	return EXIT_SUCCESS;
}
