/*
 * pdscmglobal.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdscmglobal.h
 *  \brief Archivo de definiciónn de variables globales de la biblioteca PDSCM.
 *
 *  Aquí se tienen definidas las varibles globales para la biblioteca PDSCM.
 */

#ifndef __PDSCMGLOBAL_H__
#define __PDSCMGLOBAL_H__


#ifdef __cplusplus
extern "C" {
#endif 

/** \defgroup PdsCmGlobalGroup Variables globales de la biblioteca PdsCm.
 * @{
 */

/*! Defino como variable real a un tipo float. Se puede usar cualquiera de los
 *  dos formas (PdsCmReal o float), su creación y uso, fue y es exclusivo por 
 *  facilidad en la reutilización y de portabilidad del código.
 *  \ingroup PdsCmGlobalGroup
 */
typedef float PdsCmReal;

/*! Defino el tipo de variable natural (incluye cero) como PdsCmNatural.
 *  \ingroup PdsCmGlobalGroup
 */
typedef unsigned int PdsCmNatural;

/**
 * @}
 */


#ifdef __cplusplus
}
#endif 

#endif /* __PDSCMGLOBAL_H__ */
