/*
 * testprograma1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprograma1.c
 *  \author Fernando Pujaico Rivera
 *  \date 23-01-2012
 *  \brief Programa para el testeo de grabación de audio.
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsra.h>
#include <pds/pdsda.h>

int main (int argc, char *argv[])
{
	int i;
	int id;

	FILE *fd=NULL;

	PdsDaNatural freq=8000;
	PdsDaNatural bits=10;

	PdsRecord *A=NULL;
	PdsVector *X=NULL;

	PdsRaNatural N=1024;

	X=pds_vector_new(N);

	A=pds_record_new(&freq,&bits);
	if(A==NULL)	
	{
		printf("Error creando PdsRecord\n");
		return EXIT_FAILURE;
	}

	printf("freq:%d\n",freq);
	printf("bits:%d\n",bits);

	id=pds_record_set_samples_buffer(A,N);
	if(id==FALSE)
	{
		printf("Error colocando buffer\n");
		return EXIT_FAILURE;
	}

	fd=fopen("data.dat","w");
	for (i = 0; i < 2; ++i) 
	{
		id=pds_record_read(A,X);
		if(id==FALSE)	return EXIT_FAILURE;
		
		pds_vector_fprintf(X,fd);
	}
	fclose(fd);

	pds_record_free(A);

	exit (0);
}

