/*
 * testpdsdatafunc.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testprog5.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


// ./testprog5 /text/file.c
#include <config.h>
#include <stdlib.h>
#include <pds/pdsdatafunc.h>


char *func(const char *data)
{
    char *rep=NULL;

    rep=(char*)calloc(32,1);
    sprintf(rep,"tango");
    return rep;
}

int main(int argc, char* argv[])
{

    char *cadena=NULL;
    #if defined(_WINDOWS_) || defined(_WIN32) || defined(WIN32)
    char CAD[]="C:\\path_to_file\\filename.h";
    #elif defined(__linux__)
    char CAD[]="/path_to_file/filename.h";
    #else
    char CAD[]="/path_to_file/filename.h";
    #endif
    char *DATA=NULL;
    PdsCellString *CELL=NULL;
    
    if(argc==1)
        cadena=CAD;
    else
        cadena=argv[1];

    printf("\n");
    printf("--------------------------- Names --------------------------\n");
    printf("filepath :\t%s\n",cadena);
    printf("basename :\t%s\n",pds_get_basename(cadena));
    printf("extension:\t%s\n",pds_get_filename_extension(cadena));
    printf("filename :\t%s\n",pds_get_filename(cadena));
    printf("dirname  :\t%s\n",pds_get_dirname(cadena));
    printf("other_ext:\t%s\n",pds_get_filepath_with_extension(cadena,"mp4"));
    printf("temporal :\t%s\n",pds_get_temporal_filepath(cadena,NULL));
    printf("temporal :\t%s\n",pds_get_temporal_filepath(cadena,NULL));
    printf("-------------------------------------------------------------\n");


    printf("--- Ficheros in the directory './doc'\n");
    CELL=pds_get_arquives_new("./doc",TYPE_FILE,"*",".*");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("-------------------------------------------------------------\n");


    printf("--- Directorios in the directory './doc'\n");
    CELL=pds_get_arquives_new("./doc",TYPE_DIR,"*",".*");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("-------------------------------------------------------------\n");

    printf("--- Directories in the directory '.'\n");
    CELL=pds_cell_string_new(1);
    pds_cell_string_add(CELL,".");
    CELL=pds_get_subdirs_new(CELL, "*",".*");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("-------------------------------------------------------------\n");

    printf("--- All sub-directories in the directory '.'\n");
    CELL=pds_get_all_subdirs_new(".", "*",".*");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("-------------------------------------------------------------\n");

    printf("--- All Files *.h in the directory '.' and subdirs\n");
    CELL=pds_get_all_files_new(".", "*",NULL,"*.h",NULL);
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("-------------------------------------------------------------\n");

    DATA=pds_get_filedata_string("filedata.metadata","genre=");
    if(DATA!=NULL)  printf("\n%s\n",DATA);
    printf("\n");

    CELL=pds_get_filedata_cell_string("filedata.metadata","genre=",",");
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    pds_cell_string_free(CELL);
    printf("\n");
    printf("-------------------------------------------------------------\n");


    printf("pds_get_realpath()\t\t:: %s\n\t\t\t\t   %s\n\n","src/../////Makefile",pds_get_realpath("src/../////Makefile"));
    printf("pds_get_realpath()\t\t:: %s\n\t\t\t\t   %s\n\n",".",pds_get_realpath("."));
    printf("-------------------------------------------------------------\n");

    printf("pds_get_homedir() \t\t:: %s\n\n",pds_get_homedir());
    printf("-------------------------------------------------------------\n");    


    printf("pds_get_absolute_dirname()\t:: %s\n\n",pds_get_absolute_dirname());
    printf("pds_get_absolute_programpath()\t:: %s\n\n",pds_get_absolute_programpath());
    printf("-------------------------------------------------------------\n");    

    pds_file_content_replacement("filedata.out2.metadata","filedata.metadata","=",",",func);
    printf("-------------------------------------------------------------\n");    

    pds_file_pattern_replacement("filedata.out1.metadata","filedata.metadata","sertanejo","salsa em linha");
    printf("-------------------------------------------------------------\n");    

    return EXIT_SUCCESS;
}

