/*
 * testpdsdatafunc2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsdatafunc2.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


// ./testpdsdatafunc2 /mnt/boveda/Vídeos/BAILE/SALSA testprog2.dat
#include <config.h>
#include <stdlib.h>
#include <pds/pdsdatafunc.h>

int main(int argc, char* argv[])
{
    PdsCellString *L=NULL;

    char testfile[]="XXX";
    char ltestfile[]="filedata.metadata";

    #if defined(_WINDOWS_) || defined(_WIN32) || defined(WIN32)
    char cadena[]="C:\\path_to_file\\filename.h";
    #elif defined(__linux__)
    char cadena[]="/path_to_file/filename.h";
    #else
    char cadena[]="/path_to_file/filename.h";
    #endif


    ////////////////////////////////////////////////////////////////////////////

    printf("\n<<<< Names >>>>\n");
    printf("filepath :\t%s\n",cadena);
    printf("basename :\t%s\n",pds_get_basename(cadena));
    printf("extension:\t%s\n",pds_get_filename_extension(cadena));
    printf("filename :\t%s\n",pds_get_filename(cadena));
    printf("dirname  :\t%s\n",pds_get_dirname(cadena));


    ////////////////////////////////////////////////////////////////////////////
    printf("\n<<<< About files >>>>\n");
    if(pds_is_file(ltestfile)==FALSE)
                                              printf("%20s is not a file\n",ltestfile);
    else                                      printf("%20s is a file\n",ltestfile);

    if(pds_is_file(testfile)==FALSE)
                                              printf("%20s is not a file\n",testfile);
    else                                      printf("%20s is a file\n",testfile);

    if(pds_is_dir(ltestfile)==FALSE)
                                              printf("%20s is not a dir\n",ltestfile);
    else                                      printf("%20s is a dir\n",ltestfile);

    if(pds_is_dir(testfile)==FALSE)
                                              printf("%20s is not a dir\n",testfile);
    else                                      printf("%20s is a dir\n",testfile);

    if(pds_exist_file(ltestfile)==FALSE)
                                              printf("%20s not exist the file\n",ltestfile);
    else                                      printf("%20s exist the file\n",ltestfile);

    if(pds_exist_file(testfile)==FALSE)  
                                              printf("%20s not exist the file\n",testfile);
    else                                      printf("%20s exist the file\n",testfile);

    if(pds_archive_is_accessible(ltestfile)==FALSE)  
                                              printf("%20s not is accessible\n",ltestfile);
    else                                      printf("%20s is accessible\n",ltestfile);

    if(pds_archive_is_accessible(testfile)==FALSE)
                                              printf("%20s not is accessible\n",testfile);
    else                                      printf("%20s is accessible\n",testfile);



    return EXIT_SUCCESS;
}

