/*
 * pdsargsfunc.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsargsfunc.h
 *  \author Fernando Pujaico Rivera
 *  \date 30-12-2011
 *  \brief Funciones que trabajan con argumentos pasados a programas.
 *   
 */

#ifndef __PDSARGSFUNC_H__
#define __PDSARGSFUNC_H__


#ifdef __cplusplus
extern "C" {
#endif 

#include <stdio.h>

#ifndef TRUE
	#define TRUE 1
#endif

#ifndef FALSE
	#define FALSE 0
#endif

/** \defgroup PdsArgsFuncGroup Funciones del módulo PdsArgsFunc.
 *
 *  <br>
 *  Funciones.
 * @{
 */


/** \fn int pds_get_int_param(int argc,char* const argv[],const char *data,int *param)
 *  \brief Obtiene el parámetro param de tipo int que va después del 
 *  parámetro data en una cadena de parámetros argv de argc elementos. si el 
 *  parámetro data o param no es encontrado la función retorna FALSE, y simplemente 
 *  no modifica param.
 *  Si existen parámetros data repetidos, solo se atiende al primero.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \param[out] param Parámetro existente después de data.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_get_int_param(int argc,char* const argv[],const char *data,int *param);


/** \fn int pds_get_llint_param(int argc,char* const argv[],const char *data,long int *param)
 *  \brief Obtiene el parámetro param de tipo long int que va después del 
 *  parámetro data en una cadena de parámetros argv de argc elementos. si el 
 *  parámetro data o param no es encontrado la función retorna FALSE, y simplemente 
 *  no modifica param.
 *  Si existen parámetros data repetidos, solo se atiende al primero.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \param[out] param Parámetro existente después de data.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_get_llint_param(int argc,char* const argv[],const char *data,long long *param);



/** \fn int pds_get_float_param(int argc,char* const argv[],const char *data,float *param)
 *  \brief Obtiene el parámetro param de tipo float que va después del 
 *  parámetro data en una cadena de parámetros argv de argc elementos. si el 
 *  parámetro data o param no es encontrado la función retorna FALSE, y simplemente 
 *  no modifica param.
 *  Si existen parámetros data repetidos, solo se atiende al primero.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \param[out] param Parámetro existente después de data.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_get_float_param(int argc,char* const argv[],const char *data,float *param);


/** \fn int pds_get_double_param(int argc,char* const argv[],const char *data,double *param)
 *  \brief Obtiene el parámetro param de tipo double que va después del 
 *  parámetro data en una cadena de parámetros argv de argc elementos. si el 
 *  parámetro data o param no es encontrado la función retorna FALSE, y simplemente 
 *  no modifica param.
 *  Si existen parámetros data repetidos, solo se atiende al primero.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \param[out] param Parámetro existente después de data.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_get_double_param(int argc,char* const argv[],const char *data,double *param);


/** \fn int pds_get_chars_param(int argc,char* const argv[],const char *data,char **param)
 *  \brief Obtiene la dirección del parámetro param de tipo char * que va después del 
 *  parámetro data en una cadena de parámetros argv de argc elementos. si el 
 *  parámetro data o param no es encontrado la función retorna FALSE, y simplemente 
 *  no modifica param. 
 *  Si existen parámetros data repetidos, solo se atiende al primero.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \param[out] param Parámetro existente después de data.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_get_chars_param(int argc,char* const argv[],const char *data,char **param);


/** \fn int pds_exist_param(int argc,char* const argv[],const char *data)
 *  \brief Retorna TRUE si existe el parámetro param.
 *  \param[in] argc Cantidad de elementos de argv.
 *  \param[in] argv Cadenas de caracteres con  parámetros de entrada.
 *  \param[in] data Dato a buscar en las cadenas argv.
 *  \return TRUE si todo fue bien o FALSE si no, ejemplo argv==NULL ó data==NULL.
 *  si el parámetro no es encontrado da FALSE.
 *  \ingroup PdsArgsFuncGroup
 */
int pds_exist_param(int argc,char* const argv[],const char *data);


/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif	/* __PDSARGSFUNC_H__ */ 

