/*
 * testpdscstring.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdscstring.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdscstring.h&gt; .
 *
 *  <br>
 *
 *  Este programa crea una célula llamada CellString1, le agrega datos, luego los
 *  salva en un archivo, finalmente lee los datos del archivo y crea un nueva 
 *  célula llamada CellString2.
 *
\verbatim
# Compilation command
gcc -o testpdscstring testpdscstring.c -lpdsdatafunc

# Test command
./testpdscstring 
\endverbatim
 * <br>
 * 
 */
    
#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
int main(int argc, char* argv[])
{
    PdsCellString *CellString1=NULL;
    PdsCellString *CellString2=NULL;
    char *string=NULL;
    
    char FILENAME_OUTPUT[]="testpdscstring.out.dat";
    
    // Creating a new cell string.
    CellString1=pds_cell_string_new(0);
    if(CellString1==NULL) return EXIT_FAILURE;
    
    
    // Adding new values at the top of cell string.
    pds_cell_string_add(CellString1,"1st text");
    pds_cell_string_add(CellString1,"2nd text");
    
    
    // Printing the values of the cell string.
    printf("\n<<<< CellString1 >>>>\n");
    pds_cell_string_all_printf(CellString1);
    
    
    // Saving the values of the cell string.
    pds_cell_string_save(FILENAME_OUTPUT,CellString1);
    
    
    // Concatenating the values of cell string.
    string=pds_cell_string_joint_with_end(CellString1,',');
    // Printing the values of the cell string.
    printf("\n<<<< CellString -> string >>>>\n%s\n",string);
    
    
    // Loading the values of a cell string from a file.
    CellString2=pds_cell_string_new_load(FILENAME_OUTPUT);
    if(CellString2==NULL) return EXIT_FAILURE;
    
    
    // Printing the values of the cell string.
    printf("\n<<<< CellString2 >>>>\n");
    pds_cell_string_all_printf(CellString2);
    
    
    // Optional
    remove(FILENAME_OUTPUT);
    
    return EXIT_SUCCESS;
}

