/*
 * testpdsfilesfunc2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc2.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
int main(int argc, char* argv[])
{
    const char *noexistent_file = "XXX";
    const char *  existent_file = argv[0];
    
    char *existent_dir          = pds_get_absolute_dirname(); 	
    
    printf("\n");
    
    if(pds_is_file(noexistent_file)==FALSE)     printf("It is not a file : %s\n",noexistent_file);
    else                                        printf("It is a file     : %s\n",noexistent_file);
    
    if(pds_is_file(existent_file)==FALSE)       printf("It is not a file : %s\n",existent_file);
    else                                        printf("It is a file     : %s\n",existent_file);
    
    if(pds_is_file(existent_dir)==FALSE)       printf("It is not a file : %s\n",existent_dir);
    else                                        printf("It is a file     : %s\n",existent_dir);
    
    printf("\n");
    
    if(pds_is_dir(noexistent_file)==FALSE)      printf("It is not a dir  : %s\n",noexistent_file);
    else                                        printf("It is a dir      : %s\n",noexistent_file);
    
    if(pds_is_dir(existent_file)==FALSE)        printf("It is not a dir  : %s\n",existent_file);
    else                                        printf("It is a dir      : %s\n",existent_file);
    
    if(pds_is_dir(existent_dir)==FALSE)        printf("It is not a dir  : %s\n",existent_dir);
    else                                        printf("It is a dir      : %s\n",existent_dir);
    
    printf("\n");
    
    if(pds_exist_file(noexistent_file)==FALSE)  printf("It not exist the file : %s\n",noexistent_file);
    else                                        printf("It exist the file     : %s\n",noexistent_file);
    
    if(pds_exist_file(existent_file)==FALSE)    printf("It not exist the file : %s\n",existent_file);
    else                                        printf("It exist the file     : %s\n",existent_file);
    
    if(pds_exist_file(existent_dir)==FALSE)    printf("It not exist the file : %s\n",existent_dir);
    else                                        printf("It exist the file     : %s\n",existent_dir);
        
    printf("\n");
    
    if(pds_archive_is_accessible(noexistent_file)==FALSE)   printf("It is not accessible  : %s\n",noexistent_file);
    else                                                    printf("It is accessible      : %s\n",noexistent_file);
    
    if(pds_archive_is_accessible(existent_file)==FALSE)     printf("It is not accessible  : %s\n",existent_file);
    else                                                    printf("It is accessible      : %s\n",existent_file);
    
    if(pds_archive_is_accessible(existent_dir)==FALSE)     printf("It is not accessible  : %s\n",existent_dir);
    else                                                    printf("It is accessible      : %s\n",existent_dir);
    
    printf("\n");
    
    return EXIT_SUCCESS;
}

