/*
 * testpdsfilesfunc3.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc3.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsfilesfunc.h&gt; .
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsfilesfunc3 testpdsfilesfunc3.c -lpdsdatafunc

# Test command
./testpdsfilesfunc3
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>

    
int main(int argc, char* argv[])
{
    PdsCellString *CELL=NULL;
    
    // Getting the location of directory of this program.
    char *existent_dir  = pds_get_absolute_dirname();

    // Getting the location of home directory. 	
    char *home_dir = pds_get_homedir ();
    
    
    // Getting the 1 level unhide files in a directory from char*.
    printf("\n<<<< 1 level unhide files in the directory %s >>>>\n",existent_dir);
    CELL=pds_get_arquives_new(existent_dir,TYPE_FILE,"*",".*");
    // Showing the values in the cell string.
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    // Releasing the memory of cell string.
    pds_cell_string_free(CELL);
    printf("\n");
    
    
    // Getting the 1 level unhide directories in a directory from char*.    
    printf("\n<<<< 1 level unhide directories in the directory %s >>>>\n",home_dir);
    CELL=pds_get_arquives_new(home_dir,TYPE_DIR,"*",".*");
    // Showing the values in the cell string.
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    // Releasing the memory of cell string.
    pds_cell_string_free(CELL);
    printf("\n");
    
    
    // Getting the 1 level unhide directories in a directory from cell string.    
    printf("\n<<<< 1 level unhide directories in the directory '.' >>>>\n");
    // Creating the cell string and adding the '.' directory.
    CELL=pds_cell_string_new(1);
    pds_cell_string_add(CELL,".");
    // Getting the subdirs from  a cell string. 
    CELL=pds_get_subdirs_new(CELL, "*",".*");
    // Showing the values in the returned cell string.
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    // Releasing the memory of cell string.
    pds_cell_string_free(CELL);
    printf("\n");
    
    
    // Getting recursively unhide sub directories in a directory from char *.    
    printf("\n<<<< All sub-directories in the directory '.' >>>>\n");
    CELL=pds_get_all_subdirs_new(".", "*",".*");
    // Showing the values in the returned cell string.
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    // Releasing the memory of cell string.
    pds_cell_string_free(CELL);
    printf("\n");
    
    
    // Getting recursively unhide files in a directory from char *.    
    printf("\n<<<< All Files *.h in the directory '.' and subdirs >>>>\n");
    CELL=pds_get_all_files_new(".", "*",NULL,"*.h",NULL);
    // Showing the values in the returned cell string.
    if(CELL!=NULL)  pds_cell_string_all_printf(CELL);
    // Releasing the memory of cell string.
    pds_cell_string_free(CELL);
    printf("\n");
    
    return EXIT_SUCCESS;
}

