/*
 * testpdsfilesfunc4.c
 * 
 * Copyright 2017 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \example testpdsfilesfunc4.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca &lt;pds/pdsfilesfunc.h&gt; .
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsfilesfunc4 testpdsfilesfunc4.c -lpdsdatafunc

# Test command
./testpdsfilesfunc4
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
      
int main(int argc, char* argv[])
{
    char FILE_INPUT[]  ="filedata.metadata";
    char *DATA=NULL;
    int d;
    
    PdsCellString *CELL=NULL;
        
    printf("\n");
    
    // Getting in an int data in the file, relative to "MY_FIRST_DATA".
    d=pds_get_filedata_int(FILE_INPUT,"MY_FIRST_DATA","= \t",-1);
    // Print the data.
    printf("MY_FIRST_DATA[%d]\n\n",d);
    
    
    // Getting in an int data in the file, relative to "MY_SECOND_DATA".
    DATA=pds_get_filedata_string(FILE_INPUT,"MY_SECOND_DATA","= \t","NADA");
    // Print the data.
    printf("MY_SECOND_DATA[%s]\n\n",DATA);
    
    
    // Comaparing the data in the file, relative to "MY_THIRD_DATA".
    d=pds_get_filedata_strcmp(FILE_INPUT,"MY_THIRD_DATA","= \t","TRUE");
    // Print the data.
    printf("MY_THIRD_DATA[%d]\n\n",d);
    
    
    // Getting in  a cell string separated by "," the data in the file, relative to "MY_FOURTH_DATA".
    CELL=pds_get_filedata_cell_string(FILE_INPUT,"MY_FOURTH_DATA","= \t","NADA",",");
    // Print the cell string data.
    printf("MY_FOURTH_DATA\n");     pds_cell_string_all_printf(CELL);
    // Release de cell string memory.
    pds_cell_string_free(CELL);
    
    printf("\n");
    
    
    return EXIT_SUCCESS;
}

