/*
 * testpdsstring2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testpdsstring2.c
 *  \author Fernando Pujaico Rivera
 *  \copyright GNU Public License.
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *
 *  <br>
 *
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 *
\verbatim
# Compilation command
gcc -o testpdsstring2 testpdsstring2.c -lpdsdatafunc

# Test command
./testpdsstring2
\endverbatim
O resultado seria:
\verbatim
str_ptr:[Hola <b>Fernando</b> como está <b>trucomanx</b> y <b></b>fff]
rawdata:[Fernando]
str_ptr:[ como está <b>trucomanx</b> y <b></b>fff]

str_ptr:[ como está <b>trucomanx</b> y <b></b>fff]
rawdata:[trucomanx]
str_ptr:[ y <b></b>fff]

str_ptr:[ y <b></b>fff]
rawdata:[]
str_ptr:[fff]

str_ptr:[fff]
rawdata:[(null)]
str_ptr:[(null)]
\endverbatim
 * <br>
 * 
 */

#include <stdio.h>  //printf
#include <stdlib.h> //EXIT_SUCCESS
#include <pds/pdsdatafunc.h>
    
    
int main(int argc, char* argv[])
{
    char str[]="Hola <b>Fernando</b> como está <b>trucomanx</b> y <b></b>fff";
    char *str_ptr=str;
    char *rawdata=NULL;
    
    printf("\n");
    
    do{
        printf("str_ptr:[%s]\n",str_ptr);        
    
        rawdata=pds_string_get_match_rawdata(str_ptr,"<b>","</b>",&str_ptr);
    
        printf("rawdata:[%s]\n",rawdata);

        free(rawdata);

        printf("str_ptr:[%s]\n\n",str_ptr);        
    
    }while(str_ptr!=NULL);
        
    
    return EXIT_SUCCESS;
}

