/*
 * pdsdfglobal.h
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file pdsdfglobal.h
 *  \brief Archivo de definición de variables globales de la biblioteca.
 *
 *  \author Fernando Pujaico Rivera
 */
#ifndef __PDSDFGLOBAL_H__
#define __PDSDFGLOBAL_H__

#ifdef __cplusplus
extern "C" {
#endif 

/** \defgroup PdsDfGlobalGroup variables globales de la biblioteca PDSDF.
 * @{
 */

/*! Se define una variable real.
 *  \ingroup PdsDfGlobalGroup
 */
typedef float PdsDfReal;

/*! Se define una variable natural incluyendo el cero.
 *  \ingroup PdsDfGlobalGroup
 */
typedef unsigned int PdsDfNatural;

/*! Se define una variable entera.
 *  \ingroup PdsDfGlobalGroup
 */
typedef int PdsDfInteger;


/**
 * @}
 */

#ifdef __cplusplus
}
#endif 

#endif /* __PDSDFGLOBAL_H__ */

