/*
 * testprog1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */


/** \file testprog1.c
 *  \author Fernando Pujaico Rivera
 *  \date 21-05-2011
 *  \brief Test del Filtro Iir con cero en -1 y polo en 0.9 para dos señales sinusoidales en pi/32, 3*pi/4. 
 *
 *  <br>
 *  Ademas la señal de entrada tiene una constante igual 1. La frecuencia 
 *  de muestro es 2*pi.
 *  <br>
 *  Test de un filtro IIR.
 *  \f[x[n]=1+sin(\frac{\pi}{32}n)+sin(\frac{3\pi}{4}n+\frac{\pi}{16})\f]
 *  \f[H(z)=\frac{1}{20}\frac{(1+z^{-1})}{(1-0.9z^{-1})} \f]
 *  <br>
 *  \image html test1grafico1.png "Señal de entrada x[n]."
 *  \image html test1grafico2.png "Señal de salida y[n]."
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsdf.h>
#include <pds/pdsvector.h>
#include "extras.h"
#include <math.h>

int main(int argc, char** argv)
{
	///////////////////////////////////////////////////////////////
	PdsIir *IIR1=NULL;
	PdsVector *hden=NULL;
	PdsVector *hnum=NULL;
	PdsDfReal x,y;
	PdsDfNatural n,N;
	FILE *fd=NULL;
	char DATAFILE[]="datos.txt";
	char OCTAVEFILE[]="plotinoctave.m";
	PdsVector *X=NULL;
	PdsVector *Y1=NULL;
	PdsVector *Y2=NULL;

	N=128;
	X=pds_vector_new(N);
	Y1=pds_vector_new(N);
	Y2=pds_vector_new(N);

	hden=pds_vector_new(2);
	hnum=pds_vector_new(2);
	
	/* hden=[1.0 -0.9] */
	pds_vector_set_value(hden,0,1.0);	pds_vector_set_value(hden,1,-0.9);
	/* hnum=[ 1/20 1/20] */
	pds_vector_set_value(hnum,0,1.0/20.0);	pds_vector_set_value(hnum,1,1.0/20.0);

	////////////////////////////////////////////////////////////////////////
	IIR1=pds_iir_new(hnum,hden);
	for(n=0;n<N;n++)
	{
		x=1.0+sin(M_PI*n/32.0)+sin(3.0*M_PI*n/4.0+M_PI/16.0);
		pds_iir_evaluate_value(IIR1,x,&y);

		X->V[n]=x;
		Y1->V[n]=y;
	}
	pds_iir_free(IIR1);
	////////////////////////////////////////////////////////////////////////	

	////////////////////////////////////////////////////////////////////////
	IIR1=pds_iir_new(hnum,hden);
	pds_iir_evaluate_vector(IIR1,X,Y2);
	pds_iir_free(IIR1);
	////////////////////////////////////////////////////////////////////////

	fd=fopen(DATAFILE,"w");
	if(fd==NULL)	return EXIT_FAILURE;
	pds_vector_fprintf(X,fd);
	pds_vector_fprintf(Y1,fd);
	pds_vector_fprintf(Y2,fd);
	fclose(fd);

	pds_octave_plot_lin(OCTAVEFILE,DATAFILE);

	pds_vector_free(hnum);	
	pds_vector_free(hden);	
	return EXIT_SUCCESS;
}
