#include <pds/pdsdic.h>
    
void auxiliar_function(PdsMatrix **M0,PdsRegionRect *R0,PdsMatrix **M1);
    
int main(int argc, char** argv)
{
    int ID=0;
    PdsMatrix *M0=NULL;
    PdsMatrix *M1=NULL;
    PdsRegionRect R0;
    
    // Step 0: Creating two random matrix with the same elements in the region R0 
    // of M0 and other region in M1.
    auxiliar_function(&M0,&R0,&M1);
    
    // Step 1: Creating a DIC structure
    PdsDic2D *DIC=pds_dic2d_new_from_matrices(M0,M1);
    if(DIC==NULL)   return EXIT_FAILURE;
    
    // Step 2: Tracking the region
    PdsRegionRect Rout;
    ID=pds_dic2d_tracking_region(DIC,R0,&Rout);
    
    // Step 3: Managing the results
    if(ID==PDS_DIC2D_FOUND) pds_region_rect_stylized_printf(Rout);
    else printf("ERROR: In tracking.\n");
    
    // Step 4: Releasing the memory of DIC structure and setting DIC=NULL
    pds_dic2d_destroy(&DIC);
    
    return 0;
}
    
void auxiliar_function(PdsMatrix **M0,PdsRegionRect *R0,PdsMatrix **M1)
{
    // Creating the matrix M0 and the region R0
    (*M0)=pds_matrix_new_rand(600,800);
    (*R0)=pds_region_rect(200,250,48,64);
    pds_region_rect_stylized_printf((*R0));
    
    // Creating the matrix M1 and copying the region R0 to R1
    (*M1)=pds_matrix_new_rand(600,800);
    PdsRegionRect R1=pds_region_rect(210,230,48,64);
    pds_matrix_copy_region_to_region((*M0),(*R0),(*M1),R1);
    pds_region_rect_stylized_printf(R1);
    
    printf("\n");
}
