/*
 * example_dic1.c
 * 
 * Copyright 2018 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example example_dic1.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-07-2018
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <stdlib.h>
#include <pds/pdsra.h>
#include <pds/pdsdic.h>
#include <time.h>

int main(int argc, char** argv)
{
    int ID=0;

    // Creating two matrix with only delocated region
    PdsMatrix *M0=pds_matrix_new_rand(600,800);
    PdsMatrix *M1=pds_matrix_new_rand(600,800);

    PdsRegionRect R0=pds_region_rect(50,250,48,64);
    PdsRegionRect R1=pds_region_rect_transfer(R0,64,64);

    pds_matrix_init_region(M0,R0,0.0);
    pds_matrix_init_region(M1,R1,0.0);

    pds_region_rect_stylized_printf(R0);
    pds_region_rect_stylized_printf(R1);

    // Creating a DIC structure and tracking the region

    PdsDic2D *DIC=pds_dic2d_new_from_matrices(M0,M1);
    if(DIC==NULL)   return EXIT_FAILURE;

    PdsRegionRect R;

    int N=10;
    clock_t time_init = clock ();
    for(int i=0;i<N;i++)  ID=pds_dic2d_tracking_region(DIC,R0,&R);
    clock_t time_end = clock ();
    printf("Calculating using %f seconds by point\n",(time_end-time_init)/(N*CLOCKS_PER_SEC*1.0));
    printf("last_match_corr: %f\n",DIC->last_match_corr);


    if(ID==PDS_DIC2D_FOUND)     pds_region_rect_stylized_printf(R);
    if(ID==PDS_DIC2D_NOFOUND)   printf("FAIL: Region no found.\n");
    if(ID==PDS_DIC2D_ERROR)     printf("ERROR: in tracking.\n");

    pds_matrix_mul_value(DIC->M0,255.0);
    pds_matrix_mul_value(DIC->M1,255.0);
    pds_matrix_save_bmp_with_grayscale(DIC->M0,"imagedicm0.bmp");
    pds_matrix_save_bmp_with_grayscale(DIC->M1,"imagedicm1.bmp"); 	

    // releasing the memory of DIC structure
    pds_dic2d_free(DIC);

    return EXIT_SUCCESS;
}
