/*
 * testprograma1.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprograma1.c
 *  \author Fernando Pujaico Rivera
 *  \date 10-05-2011
 *  \brief Test de la FFT y la IFFT.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsft.h>
#include <pds/pdsvector.h>
#include <pds/pdscvector.h>

#include "extras.h"

int main(int argc, char** argv)
{

	PdsFft *FFT=NULL;
	PdsGoertzel *FT=NULL;

	PdsVector *Vin=NULL;
	PdsCVector *Vout=NULL;
	PdsCVector *V=NULL;

	PdsComplex X;
	int i,N=32,k=10;

	FILE *fd=NULL;

	FFT=pds_fft_new(&N);
	FT=pds_goertzel_new(k,N);
	Vin=pds_vector_new(N);
	Vout=pds_cvector_new(N);
	V=pds_cvector_new(N);

	for(i=0;i<N/4;i++) Vin->V[i]=1.0;

	pds_fft_evaluate_real(FFT,Vout,Vin);
	pds_goertzel_evaluate_real(FT,&X,Vin);
	pds_ifft_evaluate_complex((PdsIFft*)FFT,V,Vout);

	fd=fopen("datos.dat","w");
	pds_vector_fprintf(Vin,fd);
	pds_cvector_fprintf(Vout,fd);
	pds_cvector_fprintf(V,fd);
	fclose(fd);

	printf("Vout[%d]=%e %ei\n",k,Vout->V[k].Real,Vout->V[k].Imag);
	printf("   X[%d]=%e %ei\n",k,X.Real,X.Imag);

	pds_octplot_cvector_in_png(Vout,"n","Vout[n]","graficaVout.m","graficaVout.png");
	pds_octplot_cvector_in_png(V,"n","V[n]","graficaV.m","graficaV.png");

	pds_cvector_free(V);
	pds_cvector_free(Vout);
	pds_vector_free(Vin);
	pds_goertzel_free(FT);
	pds_fft_free(FFT);

	return EXIT_SUCCESS;
}

