/*
 * testprograma2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprograma2.c
 *  \author Fernando Pujaico Rivera
 *  \date 26-01-2012
 *  \brief Test de la STFT.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsft.h>
#include <pds/pdsvector.h>
#include <pds/pdscvector.h>
#include <math.h>

#include "extras.h"


int main(int argc, char** argv)
{

	PdsStft *STFT=NULL;

	PdsVector *Vin=NULL;
	PdsCVector *Vout=NULL;
	PdsVector *V=NULL;
	PdsRaReal max;

	PdsFtNatural i,j,L=42,N=64,T=32;

	FILE *fd=NULL;

	PdsMatrix * M=NULL;

	////////////////////////////////////////////////////////////////////////

	M=pds_matrix_new (N/2,T);

	STFT=pds_stft_new(L,&N);
	pds_stft_set_window_gauss(STFT,0.5);

	Vin=pds_vector_new(L);
	Vout=pds_cvector_new(N);
	V=pds_vector_new(N);

	for(i=0;i<T;i++)
	{	
		for(j=0;j<L;j++) Vin->V[j]=sin(2.0*M_PI*(2.0 + (L*i*1.0+j)/(2.0*L))*j*1.0/L);

		pds_stft_evaluate_real(STFT,Vout,Vin);

		pds_cvector_modulus2(Vout,V);
		//pds_vector_get_max_value(V,&max);
		//pds_vector_mul_value (V, 1.0/max);

		pds_matrix_copy_vector_col(M,V,i);
	}


	pds_octplot_surf_matrix_in_png(M,"Tiempo ID","Frecuencia ID","|STFT|","graficaVout.m","graficaVout.png");

	pds_cvector_free(Vout);
	pds_vector_free(Vin);
	pds_vector_free(V);
	pds_matrix_free(M);
	pds_stft_free(STFT);

	return EXIT_SUCCESS;
}



