/*
 * testprograma3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprograma3.c
 *  \author Fernando Pujaico Rivera
 *  \date 26-01-2012
 *  \brief Test del espectrograma.
 *  
 */

#include <config.h>
#include <stdlib.h>
#include <pds/pdsft.h>
#include <pds/pdsvector.h>
#include <pds/pdscvector.h>
#include <math.h>

#include "extras.h"


int main(int argc, char** argv)
{

	PdsSpectrograph *SPECTROGRAPH=NULL;
	PdsVector	*Vin=NULL;
	PdsMatrix	*M=NULL;
	PdsFtNatural	j,L,N,T;
	int id;

	L=42;
	N=64;
	T=3;

	Vin=pds_vector_new(L*T);

	SPECTROGRAPH=pds_spectrograph_new(L,&N);
	id=pds_spectrograph_set_window_gauss(SPECTROGRAPH,0.4);

	M=pds_matrix_new (N/2,T);

	for(j=0;j<L*T;j++) Vin->V[j]=sin(2.0*M_PI*(2.0 + j/(1.0*L))*j*1.0/L);

	id=pds_spectrograph_evaluate_real(SPECTROGRAPH,M,Vin);

	pds_octplot_vector_in_png(	Vin,
					"n",
					"Vin[n]",
					"graficaVin.m",
					"graficaVin.png"
				);
	pds_octplot_image_matrix_in_png(	M,
						"Tiempo ID",
						"Frecuencia ID",
						"|SPECTROGRAPH|",
						"graficaM.m",
						"graficaM.png"
					);

	pds_vector_free(Vin);
	pds_matrix_free(M);
	pds_spectrograph_free(SPECTROGRAPH);

	return EXIT_SUCCESS;
}



