/*
 * testprograma.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprograma.c
 *  \brief Test de las funciones mas problemáticas de la biblioteca.
 *
 *  \author Fernando Pujaico Rivera
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <pds/pdsmath.h>


int main(int argc, char** argv)
{
	double x,y,z;

	for(x=0.0001;x<0.5;x=x+0.05)
	{
		y=pds_hb(x);
		z=pds_hbinv(y);		

		printf("X=%f\thb(X)=%f\tZ=hbinv(hb(X))=%f\tERROR=%f ppm\n",x,y,z,(x-z)*1000000/x);
	}

	printf("PRESS Enter ... bla bla bla ...");
	getchar();

	y=pds_integration(pds_gnorm,0,1,1000);
	printf("Test integración de la pdf gausiana int(N(0,1),0,1)=%e\n",y);

	y=pds_integration_inf(pds_gnorm,1,1000);
	printf("Test integración de la pdf gausiana int(N(0,1),1,inf)=%e\n",y);

	for(x=-9.0;x<16.0;x=x+0.1)
	{
		printf("Q(%f)=%e\tQ-1(%e)=%f\terf(%f)=%e\terfc(%f)=%e\n",x,pds_qfunc(x),pds_qfunc(x),pds_qfuncinv(pds_qfunc(x)),x,pds_erf(x),x,pds_erfc(x));
	}

	return EXIT_SUCCESS;
}
