   
#include <stdlib.h>
    
#include <pds/pdsra.h>
#include <pds/pdsnn.h>
    
int main(int argc, char** argv)
{
    PdsNnNatural i,id,Iter0,Iter1,Iter2;
    PdsNnNatural Ntraining=150;
    
    // Creating the neural network
    PdsNnNatural Larray[]={128,256,96,48,16,3};
    PdsNnNatural Nel=6;
    PdsNeuronML *MLayer=pds_neuronml_new_from_array(Larray,Nel);
    if(MLayer==NULL)    return EXIT_FAILURE;
    
    // Configuring the neural network
    PdsNnReal    Alpha=0.6;     pds_neuronml_set_alpha(MLayer,Alpha);
    PdsNnReal    Error=0.1;     pds_neuronml_set_max_error(MLayer,Error);
    PdsNnNatural MaxIter=8192;  pds_neuronml_set_max_iterations(MLayer,MaxIter);
    
    // Creating temporal vectors X and Y.
    PdsVector *X = pds_vector_new(Larray[0]);
    PdsVector *Y = pds_vector_new(Larray[Nel-1]);
    if( (X==NULL)||(Y==NULL) )  return EXIT_FAILURE;
    
    // Training the neural network
    id=0;
    for(i=0;id<Ntraining;i++)
    {
        printf("\nTraining %4d: id=%4d\n",i,id);
        
        // Training with data type 0.
        pds_generate_data_input_rand(X,1.0);
        pds_generate_data_output_mspace(Y,0);
        pds_neuronml_training(MLayer,X,Y);
        Iter0=pds_neuronml_training_results_printf(MLayer,"100");
        
        // Training with data type 1.
        pds_generate_data_input_func2pi(X,pds_generate_data_func1,6,0.05);
        pds_generate_data_output_mspace(Y,1);
        pds_neuronml_training(MLayer,X,Y);
        Iter1=pds_neuronml_training_results_printf(MLayer,"010");
        
        // Training with data type 2.
        pds_generate_data_input_func2pi(X,pds_generate_data_func1,3,0.05);
        pds_generate_data_output_mspace(Y,2);
        pds_neuronml_training(MLayer,X,Y);
        Iter2=pds_neuronml_training_results_printf(MLayer,"001");
        
        if( (Iter0==0)&&(Iter1==0)&&(Iter2==0) )
            id++;
        else
            id=0;
    }
    
    pds_neuronml_save_data(MLayer,"data_example.mlayer");
    printf("\nNeural network saved in data_example.mlayer\n\n");
        
    pds_neuronml_free(MLayer);
    
    pds_vector_free(X);
    pds_vector_free(Y);
    
    return EXIT_SUCCESS;
}

