/*
 * testprog2.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog2.c
 *  \author Fernando Pujaico Rivera
 *  \date 01-01-2020
 *  \brief Programa para el testeo de algunas funciones de la biblioteca.
 *  
 *  \n\n Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */


#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsrv.h>
#include <pds/pdsnn.h>
    
#include "octplot.h"
#include "data_work.h"

int main(int argc, char** argv)
{
	PdsNeuronML *MLayer=NULL;
	PdsNeuronML *MLayerTest=NULL;
	PdsVector *L=NULL;
	PdsVector *X=NULL;
	PdsVector *Y=NULL;
	PdsUniform *RV=NULL;

	PdsNnNatural i,Ntests,Ntraining,count=0;
	PdsNnNatural MaxIter,IterN,IterP;
	PdsNnReal Error;
	PdsNnReal Alpha;

	FILE *fd=NULL;
    
	// Creo una Random Variable para
	RV=pds_uniform_new(-1,1);

	// Creo el vector que indicará la cantidad de electrones por capa.
	// 5 Capas.
	L=pds_vector_new(6);
	L->V[0]=32;	L->V[1]=64;	L->V[2]=42; L->V[3]=28;	L->V[4]=14;	L->V[5]=7;

	// Creo El vector de entrada X.
	X=pds_vector_new(L->V[0]);
	// Creo El vector de entrada Y.
	Y=pds_vector_new(L->V[5]);

	////////////////////////////////////////////////////////////////////////

	Ntests=9;
    Ntraining=200;
	
	MLayer=pds_neuronml_new(L);
	pds_neuronml_init_weight_uniform(MLayer,RV);
	pds_neuronml_init_u_uniform(MLayer,RV);
	Alpha=0.6;      pds_neuronml_set_alpha(MLayer,Alpha);
	Error=0.2;      pds_neuronml_set_max_error(MLayer,Error);
	MaxIter=8192;   pds_neuronml_set_max_iterations(MLayer,MaxIter);
	pds_neuronml_enable_printf(MLayer);

	// Entrenando
	for(i=0;count<Ntraining;i++)
	{
		printf("\nEntrenamiento %4d\n",i);

		// Entrenando de forma negativa.
        function_data_work_init_data0(X,Y);
		pds_neuronml_training(MLayer,X,Y);
		IterN=pds_neuronml_training_results_printf(MLayer,"-1");
        

		// Entrenando de forma positiva.
        function_data_work_init_data1(X,Y);
		pds_neuronml_training(MLayer,X,Y);
		IterP=pds_neuronml_training_results_printf(MLayer,"+1");
		
		if((IterN==0)&&(IterP==0))  count++;
		else                        count=0;

	}

	fd=fopen("data.body.txt","w");
	pds_neuronml_body_fprintf(MLayer,fd);
	fclose(fd);

	MLayerTest=pds_neuronml_new(L);

	fd=fopen("data.body.txt","r");
	pds_neuronml_body_fscanf(MLayerTest,fd);
	fclose(fd);



	printf("\n\n");
	// Iterando
	for(i=0;i<Ntests;i++)
	{
        function_data_work_init_data1(X,Y);
		pds_neuronml_iterate(MLayerTest,X,Y);
		pds_neuronml_iterate_results_printf(MLayerTest,"+1");
       	function_octplot_vector_in_png(X,"n","X[n]","octfilegood.m","xgood.png");
	}


	printf("\n");
	for(i=0;i<Ntests;i++)
	{
        function_data_work_init_data0(X,Y);
		pds_neuronml_iterate(MLayerTest,X,Y);
		pds_neuronml_iterate_results_printf(MLayerTest,"-1");
    	function_octplot_vector_in_png(X,"n","X[n]","octfilebad.m","xbad.png");
	}



	pds_neuronml_free(MLayer);
	pds_neuronml_free(MLayerTest);

	printf("\n");

	pds_vector_free(X);
	pds_vector_free(Y);
	pds_vector_free(L);
	pds_uniform_free(RV);

	return EXIT_SUCCESS;
}

