/*
 * testprog_mat.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \example testprog_mat.c
 *  \author Fernando Pujaico Rivera
 *  \date 18-04-2016
 *  \brief Programa para el testeo de las funciones de la biblioteca.
 *  
 *  Este programa solo hace una prueba simple de las funciones que hice
 *  mas al tun tun.
 */

#include <config.h>
#include <stdlib.h>
#include <math.h>
#include <pds/pdsra.h>
#include <pds/pdsoctplot.h>

int main(int argc, char* argv[])
{

	int i,j,N,M;

	PdsMatrix *A=NULL;


	N=256;
	M=256;
	A=pds_matrix_new(N,M);


	for(j=0;j<N;j++)		
	for(i=0;i<M;i++)	
	{
		A->M[j][i]=0.25*sin(2*M_PI*i/N)+0.125*sin(2*2*M_PI*i/N)+0.375;
	}

    pds_octave_surf_matrix   (A,"Columnas de A","Lineas de A","Valores de A",NULL,"pds_octave_surf_matrix.png");
    pds_octave_pcolor_matrix (A,"Columnas de A","Lineas de A",NULL,"pds_octave_pcolor_matrix.png");
    pds_octave_imwrite_matrix(A,NULL,"pds_octave_imwrite_matrix.png");



	return EXIT_SUCCESS;
}

