/*
 * pdsrautils.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

#include <math.h>
#include <pds/pdsrautils.h>



/** \fn int pds_ra_ncolumns_nlines_in_file(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl)
 *  \brief Encuentra el número de columnas y de lineas dentro de un archivo.
 *  si el número de columnas no es constante dentro del archivo, la función 
 *  retorna FALSE, y carga en nc y nl la posición aproximada del error.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB como delimitarode columna y un salto de linea como delimitador de fila.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] nc Número de columnas en el archivo.
 *  \param[out] nl Número de lineas en el archivo.
 *  \return TRUE si todo fue bien o FALSE si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_ra_ncolumns_nlines_in_file(FILE *fd,PdsRaNatural *nc,PdsRaNatural *nl)
{
	PdsRaNatural i,ncol,ncold,nlin;
	char x[__MAX_CHAR_DATA_SIZE__],c;
	fpos_t *pos=NULL;
	char TAB='\t';
	char NL='\n';
	int tmp;

	if(nc==NULL)	return FALSE;
	if(nl==NULL)	return FALSE;
	if(fd==NULL)	return FALSE;

	nlin=0;
	ncol=0;
	while(feof(fd)==0)
	{
		x[0]=0;

		tmp=fscanf(fd,"%s",x);
		c=(char)fgetc(fd);	


		if(strlen(x)==0)	
		{
			if(ncol==0)	break;

			ncol=ncol-1;

			if( (ncol!=ncold)&(nlin!=1) )
			{
				*nl=nlin+1;
				*nc=ncol+1;
				rewind(fd);
				return FALSE;
			}
		}

		if(c==TAB)	
		{
			ncol=ncol+1;
		}

		if(c==NL)	
		{
			
			nlin=nlin+1;
			if( (ncol!=ncold)&(nlin!=1) )
			{
				*nl=nlin;
				*nc=ncol+1;
				rewind(fd);
				return FALSE;
			}
			ncold=ncol;
			ncol=0;
		}
	}

	rewind(fd);

	if(ncol==0)	FALSE;
	if(nlin==0)	FALSE;

	*nl=nlin;
	*nc=ncold+1;

	return TRUE;
}

/** \fn int pds_ra_nelements_in_file(FILE *fd,PdsRaNatural *n)
 *  \brief Encuentra el número de elementos dentro de un archivo.
 *  Al terminar coloca el fd en el inicio del archivo.
 *  Usa TAB o un salto de linea como delimitador de elemento.
 *  \param[in] fd Descriptor del fichero.
 *  \param[out] n Número de elementos en el archivo.
 *  \return TRUE si todo fue bien o FALSE si no. (ej. fd==NULL)
 *  \ingroup PdsRaUtilsGroup
 */
int pds_ra_nelements_in_file(FILE *fd,PdsRaNatural *n)
{
	PdsRaNatural i;
	int tmp;
	char x[__MAX_CHAR_DATA_SIZE__];

	if(fd==NULL)	return FALSE;
	if( n==NULL)	return FALSE;

	*n=0;

	while(feof(fd)==0)
	{
		x[0]=0;
		tmp=fscanf(fd,"%s",x);
		if(strlen(x)==0)	break;
		(*n)++;
	}
	rewind(fd);
	if(*n==0)	FALSE;

	return TRUE;
}


