/*
 * testprog3.c
 * 
 * Copyright 2011 Fernando Pujaico Rivera <fernando.pujaico.rivera@gmail.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 */

/** \file testprog3.c
 *  \author Fernando Pujaico Rivera
 *  \date 02-02-2012
 *  \brief Programa para el testeo de la fifo.
 *  
 *  \n\n Este programa hace una prueba de la fifo cuando dos procesos intentan 
 *  acceder a la misma.
 */

#include <stdlib.h>
#include <math.h>

#include <pds/pdsra.h>

#include <pds/pdsfifo.h>
#include "biblioteca/pdsfifo.c"

#include <pthread.h>
// gcc  -lpthread -lpdsra -lm -Iheaders testprog3.c -o testprog3
PdsFifo *FIFO=NULL;

void *funcionDelThread(void *x)
{
	PdsVector *V=NULL;
	int id,i;
	
	V=pds_vector_new(4);

	i=0;
	do{
		id=pds_fifo_read(FIFO,V);
		if(id==TRUE)
		{
			printf("Nnodes=%2d : id=%6d : V : ",FIFO->Nnodes,i);
			pds_vector_printf(V);
			i++;
		}
		
	}while(1);
	
	return x;	
}

int main(int argc, char **argv)
{
	PdsVector *V=NULL;
	int i,j,id;
	double y;
	PdsRaNatural N=16;
	PdsRaNatural M=4;
	pthread_t idHilo;

	V=pds_vector_new(M*2);
	
	FIFO=pds_fifo_new(N,M);

	pthread_create(&idHilo,NULL, funcionDelThread,NULL); 

	for(i=0;i<1000;i++)
	{
		pds_vector_init_value(V,i);
		do
		{
			id=pds_fifo_write(FIFO,V);
		}while(id==FALSE);
		
		//for(j=0;j<100000;j++)	y=log(i*1.0+1.1+sin(i*i*1.0));
	}

	id=0;
	while(FIFO->Nnodes!=0)
	{
		if(id!=FIFO->Nnodes)	printf("\n[Nnodes=%d]\n",FIFO->Nnodes);
		id=FIFO->Nnodes;
	}

	pds_fifo_free(FIFO);
		
	return 0;
}
